/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states;

import java.util.Map;
import java.util.Set;
import org.pentaho.reporting.engine.classic.core.CrosstabCellBody;
import org.pentaho.reporting.engine.classic.core.DetailsFooter;
import org.pentaho.reporting.engine.classic.core.DetailsHeader;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupDataBody;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.NoDataBand;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.PageFooter;
import org.pentaho.reporting.engine.classic.core.PageHeader;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportFooter;
import org.pentaho.reporting.engine.classic.core.ReportHeader;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.Watermark;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.MasterReportType;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;

public class ReportDefinitionImpl
extends Section
implements ReportDefinition {
    private ReportHeader reportHeader;
    private ReportFooter reportFooter;
    private PageHeader pageHeader;
    private PageFooter pageFooter;
    private Watermark watermark;
    private PageDefinition pageDefinition;
    private String query;
    private Group rootGroup;
    private int queryLimit;
    private int queryTimeout;

    public ReportDefinitionImpl(MasterReport report, PageDefinition pageDefinition) throws ReportProcessingException {
        super(report.getObjectID());
        this.copyReport(report, pageDefinition);
    }

    public ReportDefinitionImpl(SubReport report, PageDefinition pageDefinition, Section parentSection) throws ReportProcessingException {
        super(report.getObjectID());
        this.copyReport(report, pageDefinition);
        this.setParent(parentSection);
    }

    private void copyReport(ReportDefinition report, PageDefinition pageDefinition) {
        if (pageDefinition == null) {
            throw new NullPointerException();
        }
        this.rootGroup = report.getRootGroup().derive(true);
        this.reportFooter = (ReportFooter)report.getReportFooter().derive(true);
        this.reportHeader = (ReportHeader)report.getReportHeader().derive(true);
        this.pageFooter = (PageFooter)report.getPageFooter().derive(true);
        this.pageHeader = (PageHeader)report.getPageHeader().derive(true);
        this.watermark = (Watermark)report.getWatermark().derive(true);
        this.pageDefinition = pageDefinition;
        this.query = report.getQuery();
        this.copyAttributes(report.getAttributes());
        String[] attrExprNamespaces = report.getAttributeExpressionNamespaces();
        for (int i = 0; i < attrExprNamespaces.length; ++i) {
            String namespace = attrExprNamespaces[i];
            String[] attributeNames = report.getAttributeExpressionNames(namespace);
            for (int j = 0; j < attributeNames.length; ++j) {
                String name = attributeNames[j];
                this.setAttributeExpression(namespace, name, report.getAttributeExpression(namespace, name));
            }
        }
        this.getStyle().copyFrom(report.getStyle());
        Set<Map.Entry<StyleKey, Expression>> styleExpressionEntries = report.getStyleExpressions().entrySet();
        for (Map.Entry<StyleKey, Expression> entry : styleExpressionEntries) {
            this.setStyleExpression(entry.getKey(), entry.getValue());
        }
        this.registerAsChild(this.rootGroup);
        this.registerAsChild(this.reportHeader);
        this.registerAsChild(this.reportFooter);
        this.registerAsChild(this.pageHeader);
        this.registerAsChild(this.pageFooter);
        this.registerAsChild(this.watermark);
        this.queryLimit = report.getQueryLimit();
        this.queryTimeout = report.getQueryTimeout();
        this.setName(report.getName());
        this.setChangeTracker(report.getChangeTracker());
    }

    @Override
    public int getQueryLimit() {
        return this.queryLimit;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public ReportHeader getReportHeader() {
        return this.reportHeader;
    }

    @Override
    public ReportFooter getReportFooter() {
        return this.reportFooter;
    }

    @Override
    public PageHeader getPageHeader() {
        return this.pageHeader;
    }

    @Override
    public PageFooter getPageFooter() {
        return this.pageFooter;
    }

    @Override
    public ItemBand getItemBand() {
        Group group = this.getInnerMostGroup();
        GroupBody body = group.getBody();
        if (body instanceof GroupDataBody) {
            GroupDataBody dataBody = (GroupDataBody)body;
            return dataBody.getItemBand();
        }
        return null;
    }

    @Override
    public CrosstabCellBody getCrosstabCellBody() {
        Group group = this.getInnerMostGroup();
        GroupBody body = group.getBody();
        if (body instanceof CrosstabCellBody) {
            return (CrosstabCellBody)body;
        }
        return null;
    }

    @Override
    public DetailsHeader getDetailsHeader() {
        Group group = this.getInnerMostGroup();
        GroupBody body = group.getBody();
        if (body instanceof GroupDataBody) {
            GroupDataBody dataBody = (GroupDataBody)body;
            return dataBody.getDetailsHeader();
        }
        return null;
    }

    @Override
    public DetailsFooter getDetailsFooter() {
        Group group = this.getInnerMostGroup();
        GroupBody body = group.getBody();
        if (body instanceof GroupDataBody) {
            GroupDataBody dataBody = (GroupDataBody)body;
            return dataBody.getDetailsFooter();
        }
        return null;
    }

    @Override
    public Group getRootGroup() {
        return this.rootGroup;
    }

    private Group getInnerMostGroup() {
        Group existingGroup = this.rootGroup;
        GroupBody gb = existingGroup.getBody();
        while (gb != null) {
            int count = gb.getElementCount();
            GroupBody locatedBody = null;
            for (int i = 0; i < count; ++i) {
                Element element = gb.getElement(i);
                if (!(element instanceof Group)) continue;
                existingGroup = (Group)element;
                locatedBody = existingGroup.getBody();
                break;
            }
            if (locatedBody == null) {
                gb = null;
                continue;
            }
            gb = locatedBody;
        }
        return existingGroup;
    }

    @Override
    public NoDataBand getNoDataBand() {
        Group group = this.getInnerMostGroup();
        GroupBody body = group.getBody();
        if (body instanceof GroupDataBody) {
            GroupDataBody dataBody = (GroupDataBody)body;
            return dataBody.getNoDataBand();
        }
        return null;
    }

    @Override
    public int getGroupCount() {
        int result = 1;
        Group existingGroup = this.rootGroup;
        GroupBody gb = existingGroup.getBody();
        while (gb != null) {
            int count = gb.getElementCount();
            boolean found = false;
            for (int i = 0; i < count; ++i) {
                Element element = gb.getElement(i);
                if (!(element instanceof Group)) continue;
                existingGroup = (Group)element;
                ++result;
                gb = existingGroup.getBody();
                found = true;
                break;
            }
            if (found) continue;
            gb = null;
        }
        return result;
    }

    @Override
    public Group getGroup(int groupIndex) {
        if (groupIndex < 0) {
            throw new IllegalArgumentException("GroupCount must not be negative");
        }
        if (groupIndex == 0) {
            return this.rootGroup;
        }
        int result = 0;
        Group existingGroup = this.rootGroup;
        GroupBody gb = existingGroup.getBody();
        while (gb != null) {
            int count = gb.getElementCount();
            boolean found = false;
            for (int i = 0; i < count; ++i) {
                Element element = gb.getElement(i);
                if (!(element instanceof Group)) continue;
                existingGroup = (Group)element;
                if (++result == groupIndex) {
                    return existingGroup;
                }
                gb = existingGroup.getBody();
                found = true;
                break;
            }
            if (found) continue;
            gb = null;
        }
        throw new IndexOutOfBoundsException("No group defined at the given index " + groupIndex + " . Max-index=" + result);
    }

    @Override
    public ReportDefinitionImpl clone() {
        ReportDefinitionImpl report = (ReportDefinitionImpl)super.clone();
        report.rootGroup = this.rootGroup.clone();
        report.pageFooter = (PageFooter)this.pageFooter.clone();
        report.pageHeader = (PageHeader)this.pageHeader.clone();
        report.reportFooter = (ReportFooter)this.reportFooter.clone();
        report.reportHeader = (ReportHeader)this.reportHeader.clone();
        report.watermark = (Watermark)this.watermark.clone();
        report.pageDefinition = this.pageDefinition;
        report.setParent(this.getParentSection());
        report.registerAsChild(report.rootGroup);
        report.registerAsChild(report.reportHeader);
        report.registerAsChild(report.reportFooter);
        report.registerAsChild(report.pageHeader);
        report.registerAsChild(report.pageFooter);
        report.registerAsChild(report.watermark);
        return report;
    }

    @Override
    public ReportDefinitionImpl derive(boolean preserveElementInstanceIds) {
        ReportDefinitionImpl report = (ReportDefinitionImpl)super.derive(preserveElementInstanceIds);
        report.rootGroup = this.rootGroup.derive(preserveElementInstanceIds);
        report.pageFooter = (PageFooter)this.pageFooter.derive(preserveElementInstanceIds);
        report.pageHeader = (PageHeader)this.pageHeader.derive(preserveElementInstanceIds);
        report.reportFooter = (ReportFooter)this.reportFooter.derive(preserveElementInstanceIds);
        report.reportHeader = (ReportHeader)this.reportHeader.derive(preserveElementInstanceIds);
        report.watermark = (Watermark)this.watermark.derive(preserveElementInstanceIds);
        report.pageDefinition = this.pageDefinition;
        report.setParent(this.getParentSection());
        report.registerAsChild(report.rootGroup);
        report.registerAsChild(report.reportHeader);
        report.registerAsChild(report.reportFooter);
        report.registerAsChild(report.pageHeader);
        report.registerAsChild(report.pageFooter);
        report.registerAsChild(report.watermark);
        return report;
    }

    @Override
    public Watermark getWatermark() {
        return this.watermark;
    }

    @Override
    public PageDefinition getPageDefinition() {
        return this.pageDefinition;
    }

    @Override
    public ReportDefinition getReportDefinition() {
        return this;
    }

    @Override
    public ReportDefinition getMasterReport() {
        if (this.getElementType() instanceof MasterReportType) {
            return this;
        }
        return super.getMasterReport();
    }

    @Override
    protected void removeElement(Element element) {
        throw new UnsupportedOperationException("Method 'removeElement' is not supported in the read-only report-definition.");
    }

    @Override
    public void setElementAt(int position, Element element) {
        throw new UnsupportedOperationException("Method 'removeElement' is not supported in the read-only report-definition.");
    }

    @Override
    public int getElementCount() {
        return 6;
    }

    @Override
    public Element getElement(int index) {
        switch (index) {
            case 0: {
                return this.pageHeader;
            }
            case 1: {
                return this.reportHeader;
            }
            case 2: {
                return this.rootGroup;
            }
            case 3: {
                return this.reportFooter;
            }
            case 4: {
                return this.pageFooter;
            }
            case 5: {
                return this.watermark;
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

