/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util;

import java.util.ArrayList;

public class RingBuffer<T> {
    private ArrayList<T> values;
    private int index;
    private int count;
    private int size;

    public RingBuffer(int size) {
        if (size < 1) {
            throw new IllegalArgumentException();
        }
        this.size = size;
        this.values = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this.values.add(null);
        }
    }

    public void add(T value) {
        this.values.set(this.index, value);
        ++this.index;
        ++this.count;
        if (this.index == this.size) {
            this.index = 0;
        }
    }

    public void replaceLastAdded(T value) {
        if (this.count == 0) {
            this.add(value);
            return;
        }
        --this.count;
        this.index = this.index == 0 ? this.size - 1 : --this.index;
        this.add(value);
    }

    public T getFirstValue() {
        if (this.count < this.size) {
            return this.values.get(0);
        }
        return this.values.get(this.index);
    }

    public T getLastValue() {
        int lastIndex = this.index == 0 ? this.size - 1 : this.index - 1;
        return this.values.get(lastIndex);
    }

    public int size() {
        return this.size;
    }

    public T get(int index) {
        return this.values.get(index);
    }

    public void set(int index, T value) {
        this.values.set(index, value);
    }

    public void resize(int newSize) {
        if (newSize <= 0) {
            throw new IllegalStateException();
        }
        if (newSize > this.values.size()) {
            this.values.clear();
            for (int i = 0; i < newSize; ++i) {
                this.values.add(null);
            }
        }
        this.size = newSize;
    }
}

