/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.shim.oozie;

import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.WorkflowJob;
import org.pentaho.oozie.shim.api.OozieClientException;
import org.pentaho.oozie.shim.api.OozieJob;

public class OozieJobInfoImpl
implements OozieJob {
    private final String id;
    private final OozieClient oozieClient;

    public OozieJobInfoImpl(String id, OozieClient oozieClient) {
        this.id = id;
        this.oozieClient = oozieClient;
    }

    public boolean didSucceed() throws OozieClientException {
        try {
            return this.oozieClient.getJobInfo(this.id).getStatus().equals((Object)WorkflowJob.Status.SUCCEEDED);
        }
        catch (org.apache.oozie.client.OozieClientException e) {
            throw new OozieClientException((Throwable)e, e.getErrorCode());
        }
    }

    public String getId() {
        return this.id;
    }

    public String getJobLog() throws OozieClientException {
        try {
            return this.oozieClient.getJobLog(this.id);
        }
        catch (org.apache.oozie.client.OozieClientException e) {
            throw new OozieClientException((Throwable)e, e.getErrorCode());
        }
    }

    public boolean isRunning() throws OozieClientException {
        try {
            return this.oozieClient.getJobInfo(this.id).getStatus().equals((Object)WorkflowJob.Status.RUNNING);
        }
        catch (org.apache.oozie.client.OozieClientException e) {
            throw new OozieClientException((Throwable)e, e.getErrorCode());
        }
    }
}

