/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.common.ui.services;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.SimpleContentGenerator;

public class ChartSeriesColorContentGenerator
extends SimpleContentGenerator {
    private static final long serialVersionUID = -2308151094352245100L;
    public static final String TYPE_RELATIONAL = "relational";
    public static final String TYPE_MDX = "mdx";
    private Log logger = LogFactory.getLog(ChartSeriesColorContentGenerator.class);

    public void createContent(OutputStream output) throws Exception {
        IParameterProvider params = (IParameterProvider)this.parameterProviders.get("request");
        String type = params.getStringParameter("type", TYPE_MDX);
        if (!(type = type.toLowerCase()).equals(TYPE_RELATIONAL) && !type.equals(TYPE_MDX)) {
            throw new IllegalStateException("Unknown chart series color model type: " + type);
        }
        IPluginResourceLoader resLoader = this.getPluginResourceLoader();
        String json = null;
        try {
            json = resLoader.getResourceAsString(ChartSeriesColorContentGenerator.class, "resources/chartseriescolor/" + type + ".json");
            if (json == null) {
                json = "{}";
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.toString(), e);
        }
        output.write(json.getBytes());
    }

    public String getMimeType() {
        return "application/json";
    }

    public Log getLogger() {
        return this.logger;
    }

    IPluginResourceLoader getPluginResourceLoader() {
        return (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
    }
}

