/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import org.apache.calcite.linq4j.CorrelateJoinType;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.parser.SqlParserPos;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SemiJoinType implements SqlLiteral.SqlSymbol
{
    INNER,
    LEFT,
    SEMI,
    ANTI;


    public SqlLiteral symbol(SqlParserPos pos) {
        return SqlLiteral.createSymbol(this, pos);
    }

    public static SemiJoinType of(JoinRelType joinType) {
        switch (joinType) {
            case INNER: {
                return INNER;
            }
            case LEFT: {
                return LEFT;
            }
        }
        throw new IllegalArgumentException("Unsupported join type for semi-join " + (Object)((Object)joinType));
    }

    public JoinRelType toJoinType() {
        switch (this) {
            case INNER: {
                return JoinRelType.INNER;
            }
            case LEFT: {
                return JoinRelType.LEFT;
            }
        }
        throw new IllegalStateException("Unable to convert " + this + " to JoinRelType");
    }

    public CorrelateJoinType toLinq4j() {
        switch (this) {
            case INNER: {
                return CorrelateJoinType.INNER;
            }
            case LEFT: {
                return CorrelateJoinType.LEFT;
            }
            case SEMI: {
                return CorrelateJoinType.SEMI;
            }
            case ANTI: {
                return CorrelateJoinType.ANTI;
            }
        }
        throw new IllegalStateException("Unable to convert " + this + " to JoinRelType");
    }

    public boolean returnsJustFirstInput() {
        switch (this) {
            case INNER: 
            case LEFT: {
                return false;
            }
            case SEMI: 
            case ANTI: {
                return true;
            }
        }
        throw new IllegalStateException("Unable to convert " + this + " to JoinRelType");
    }
}

