/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.Calendar;
import org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;

public class SqlTimeLiteral
extends SqlAbstractDateTimeLiteral {
    SqlTimeLiteral(Calendar t, int precision, boolean hasTZ, SqlParserPos pos) {
        super(t, hasTZ, SqlTypeName.TIME, precision, "HH:mm:ss", pos);
    }

    SqlTimeLiteral(Calendar t, int precision, boolean hasTZ, String format, SqlParserPos pos) {
        super(t, hasTZ, SqlTypeName.TIME, precision, format, pos);
    }

    public SqlNode clone(SqlParserPos pos) {
        return new SqlTimeLiteral((Calendar)this.value, this.precision, this.hasTimeZone, this.formatString, pos);
    }

    public String toString() {
        return "TIME '" + this.toFormattedString() + "'";
    }

    public String toFormattedString() {
        String result = this.getTime().toString(this.formatString);
        Calendar cal = this.getCal();
        if (this.precision > 0) {
            assert (this.precision <= 3);
            String digits = Long.toString(cal.getTimeInMillis());
            result = result + "." + digits.substring(digits.length() - 3, digits.length() - 3 + this.precision);
        } else assert (0 == cal.get(14));
        return result;
    }
}

