/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.caching.ri.impl;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import javax.cache.processor.MutableEntry;
import org.pentaho.caching.api.Constants;

abstract class WrappedCache<K, V>
implements javax.cache.Cache<K, V> {
    private final Cache<K, V> cache;
    private volatile boolean closed = false;

    public WrappedCache(Cache<K, V> guavaCache) {
        this.cache = guavaCache;
    }

    protected Optional<V> tryGet(K key) {
        this.assertNotClosed();
        return Optional.fromNullable((Object)this.cache.getIfPresent(key));
    }

    protected void assertNotClosed() throws CacheException {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (Object)"Cache is closed");
    }

    public V get(K key) {
        this.assertNotClosed();
        return (V)this.tryGet(key).orNull();
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        this.assertNotClosed();
        return this.cache.getAllPresent(keys);
    }

    public boolean containsKey(K key) {
        this.assertNotClosed();
        return this.tryGet(key).isPresent();
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        this.assertNotClosed();
    }

    public void put(K key, V value) {
        this.assertNotClosed();
        this.cache.put(key, value);
    }

    public V getAndPut(K key, V value) {
        this.assertNotClosed();
        return this.cache.asMap().replace(key, value);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.assertNotClosed();
        this.cache.putAll(map);
    }

    public boolean putIfAbsent(K key, V value) {
        this.assertNotClosed();
        return this.cache.asMap().putIfAbsent(key, value) == null;
    }

    public boolean remove(K key) {
        this.assertNotClosed();
        return this.cache.asMap().remove(key) != null;
    }

    public boolean remove(K key, V oldValue) {
        this.assertNotClosed();
        return this.cache.asMap().remove(key, oldValue);
    }

    public V getAndRemove(K key) {
        this.assertNotClosed();
        return this.cache.asMap().remove(key);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        this.assertNotClosed();
        return this.cache.asMap().replace(key, oldValue, newValue);
    }

    public boolean replace(K key, V value) {
        this.assertNotClosed();
        return this.cache.asMap().replace(key, value) != null;
    }

    public V getAndReplace(K key, V value) {
        this.assertNotClosed();
        return this.cache.asMap().replace(key, value);
    }

    public void removeAll(Set<? extends K> keys) {
        this.assertNotClosed();
        this.cache.invalidateAll(keys);
    }

    public void removeAll() {
        this.assertNotClosed();
        this.cache.asMap().clear();
    }

    public void clear() {
        this.assertNotClosed();
        this.cache.asMap().clear();
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        this.assertNotClosed();
        return (T)this.invokeAll((Set<? extends K>)ImmutableSet.of(key), entryProcessor, arguments).get(key).get();
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.assertNotClosed();
        ImmutableMap.Builder resultMap = ImmutableMap.builder();
        for (final K key : keys) {
            final AtomicBoolean removed = new AtomicBoolean(false);
            final AtomicBoolean updated = new AtomicBoolean(false);
            MutableEntry entry = new MutableEntry<K, V>(){
                Optional<V> value;
                {
                    this.value = WrappedCache.this.tryGet(key);
                }

                public K getKey() {
                    return key;
                }

                public V getValue() {
                    return this.value.orNull();
                }

                public <U> U unwrap(Class<U> clazz) {
                    return (U)Constants.unwrap((Object)this, clazz);
                }

                public boolean exists() {
                    return this.value.isPresent();
                }

                public void remove() {
                    removed.set(true);
                }

                public void setValue(V value) {
                    this.value = Optional.of(value);
                    updated.set(true);
                }
            };
            final Object result = entryProcessor.process(entry, arguments);
            if (removed.get()) {
                this.remove(key);
            } else if (updated.get()) {
                this.put(key, entry.getValue());
            }
            resultMap.put(key, (Object)new EntryProcessorResult<T>(){

                public T get() throws EntryProcessorException {
                    return result;
                }
            });
        }
        return resultMap.build();
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.assertNotClosed();
        return FluentIterable.from(this.cache.asMap().entrySet()).transform(new Function<Map.Entry<K, V>, Cache.Entry<K, V>>(){

            public Cache.Entry<K, V> apply(final Map.Entry<K, V> mapEntry) {
                return new Cache.Entry<K, V>(){

                    public K getKey() {
                        return mapEntry.getKey();
                    }

                    public V getValue() {
                        return mapEntry.getValue();
                    }

                    public <T> T unwrap(Class<T> clazz) {
                        return (T)Constants.unwrap((Object)this, clazz);
                    }
                };
            }
        }).iterator();
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.assertNotClosed();
        throw new CacheException("CacheEntryListeners are not yet supported");
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.assertNotClosed();
        throw new CacheException("CacheEntryListeners are not yet supported");
    }

    public void close() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)Constants.unwrap((Object)this, clazz);
    }
}

