/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.reporting.platform.plugin.AuditWrapper;
import org.pentaho.reporting.platform.plugin.ParameterContentGenerator;
import org.pentaho.reporting.platform.plugin.SimpleReportingComponent;
import org.pentaho.reporting.platform.plugin.async.IJobIdGenerator;
import org.pentaho.reporting.platform.plugin.async.IPentahoAsyncExecutor;
import org.pentaho.reporting.platform.plugin.async.PentahoAsyncExecutor;
import org.pentaho.reporting.platform.plugin.async.PentahoAsyncReportExecution;
import org.pentaho.reporting.platform.plugin.async.ReportListenerThreadHolder;
import org.pentaho.reporting.platform.plugin.staging.AsyncJobFileStagingHandler;

public class BackgroundJobReportContentGenerator
extends ParameterContentGenerator {
    private static final Log logger = LogFactory.getLog(BackgroundJobReportContentGenerator.class);
    private static final String PRPTI = ".prpti";
    private static final String RESERVED_ID = "reservedId";
    private static final String PATH = "path";
    private static final String HTTPRESPONSE = "httpresponse";
    private static final String HTTPREQUEST = "httprequest";
    static final String REDIRECT_PREFIX = "/plugin/reporting/api/jobs/";
    static final String REDIRECT_POSTFIX = "/status";

    @Override
    public void createContent(OutputStream outputStream) throws Exception {
        IParameterProvider requestParams = this.getRequestParameters();
        RepositoryFile prptFile = this.resolvePrptFile(requestParams);
        this.createReportContent(prptFile.getId(), prptFile.getPath());
    }

    public void createReportContent(Serializable fileId, String path) throws Exception {
        this.createReportContent(fileId, path, new SimpleReportingComponent(), new AuditWrapper());
    }

    public void createReportContent(Serializable fileId, String path, SimpleReportingComponent reportComponent, AuditWrapper audit) throws Exception {
        Map<String, Object> inputs = this.createInputs();
        ReportListenerThreadHolder.setRequestId(this.instanceId);
        audit.audit(this.userSession.getId(), this.userSession.getName(), path, this.getObjectName(), ((Object)((Object)this)).getClass().getName(), "execution", this.instanceId, "", 0.0f, (ILogger)this);
        reportComponent.setReportFileId(fileId);
        reportComponent.setPaginateOutput(true);
        reportComponent.setForceDefaultOutputTarget(false);
        reportComponent.setDefaultOutputTarget("table/html;page-mode=page");
        if (path.endsWith(PRPTI)) {
            reportComponent.setForceUnlockPreferredOutput(true);
        }
        reportComponent.setInputs(inputs);
        AsyncJobFileStagingHandler handler = new AsyncJobFileStagingHandler(this.userSession);
        reportComponent.setOutputStream(handler.getStagingOutputStream());
        PentahoAsyncReportExecution asyncExec = new PentahoAsyncReportExecution(path, reportComponent, handler, this.userSession, this.instanceId, audit);
        IPentahoAsyncExecutor executor = (IPentahoAsyncExecutor)PentahoSystem.get(PentahoAsyncExecutor.class, (String)"IPentahoAsyncExecutor", null);
        if (reportComponent.validate()) {
            UUID reservedId = this.getReservedId();
            UUID uuid = executor.addTask(asyncExec, this.userSession, reservedId);
            this.sendSuccessRedirect(uuid);
        } else {
            audit.audit(this.userSession.getId(), this.userSession.getName(), path, this.getObjectName(), ((Object)((Object)this)).getClass().getName(), "failed", this.instanceId, "", 0.0f, (ILogger)this);
            this.sendErrorResponse();
        }
    }

    private UUID getReservedId() throws IllegalStateException {
        UUID uuid;
        IJobIdGenerator iJobIdGenerator = (IJobIdGenerator)PentahoSystem.get(IJobIdGenerator.class);
        UUID failover = UUID.randomUUID();
        String precomputedId = this.getRequestParameters().getStringParameter(RESERVED_ID, failover.toString());
        try {
            uuid = UUID.fromString(precomputedId);
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)"Wrong uuid came from client side: ", (Throwable)e);
            return failover;
        }
        if (iJobIdGenerator != null && iJobIdGenerator.acquire(this.userSession, uuid)) {
            return uuid;
        }
        return failover;
    }

    protected void sendErrorResponse() throws IOException {
        HttpServletResponse httpResponse = this.getServletResponse();
        httpResponse.setStatus(500);
    }

    protected void sendSuccessRedirect(UUID uuid) throws IOException {
        HttpServletResponse httpResponse = this.getServletResponse();
        HttpServletRequest servletRequest = this.getServletRequest();
        String contextUrl = servletRequest.getContextPath();
        httpResponse.setStatus(102);
        httpResponse.sendRedirect(contextUrl + REDIRECT_PREFIX + uuid.toString() + REDIRECT_POSTFIX);
    }

    protected HttpServletResponse getServletResponse() {
        IParameterProvider pathProviders = (IParameterProvider)this.parameterProviders.get(PATH);
        Object httpResponseObj = pathProviders.getParameter(HTTPRESPONSE);
        return (HttpServletResponse)HttpServletResponse.class.cast(httpResponseObj);
    }

    protected HttpServletRequest getServletRequest() {
        IParameterProvider pathProviders = (IParameterProvider)this.parameterProviders.get(PATH);
        Object httpRequestObj = pathProviders.getParameter(HTTPREQUEST);
        return (HttpServletRequest)HttpServletRequest.class.cast(httpRequestObj);
    }

    @Override
    public Log getLogger() {
        return logger;
    }

    @Override
    public String getMimeType() {
        return "text/html";
    }

    static interface HttpServletResponse102
    extends HttpServletResponse {
        public static final int SC_PROCESSING = 102;
    }
}

