/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.owasp.encoder.Encode;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.mt.ITenantedPrincipleNameResolver;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.reporting.engine.classic.core.DefaultReportEnvironment;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.CSVQuoter;
import org.pentaho.reporting.platform.plugin.messages.Messages;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class PentahoReportEnvironment
extends DefaultReportEnvironment {
    private static final Log logger = LogFactory.getLog(PentahoReportEnvironment.class);
    private HashMap<String, String> cache;
    private String clText;
    private String repositoryPath;

    @Deprecated
    public PentahoReportEnvironment(Configuration configuration) {
        this(configuration, null);
    }

    @Deprecated
    public PentahoReportEnvironment(Configuration configuration, String clText) {
        super(configuration);
        this.clText = clText;
        this.setLocale(LocaleHelper.getLocale());
    }

    public PentahoReportEnvironment(Configuration configuration, String clText, String repositoryPath) {
        super(configuration);
        this.clText = clText;
        this.repositoryPath = repositoryPath != null ? repositoryPath.replaceAll("/", ":") : repositoryPath;
        this.setLocale(LocaleHelper.getLocale());
    }

    public String getEnvironmentProperty(String key) {
        Object environmentProperty;
        String cached;
        if (key == null) {
            throw new NullPointerException();
        }
        if ("contentLink".equals(key)) {
            return this.clText;
        }
        if (this.cache == null) {
            this.cache = new HashMap();
        }
        if ((cached = this.cache.get(key)) != null) {
            return cached;
        }
        IPentahoSession session = PentahoSessionHolder.getSession();
        if (PentahoSystem.getApplicationContext() != null) {
            String fullyQualifiedServerUrl = PentahoSystem.getApplicationContext().getFullyQualifiedServerURL();
            if ("serverBaseURL".equals(key)) {
                String baseServerURL = this.getBaseServerURL(fullyQualifiedServerUrl);
                this.cache.put(key, baseServerURL);
                return baseServerURL;
            }
            if ("pentahoBaseURL".equals(key)) {
                this.cache.put(key, fullyQualifiedServerUrl);
                return fullyQualifiedServerUrl;
            }
            if ("solutionRoot".equals(key)) {
                String solutionRoot = PentahoSystem.getApplicationContext().getSolutionPath("");
                this.cache.put(key, solutionRoot);
                return solutionRoot;
            }
            if ("hostColonPort".equals(key)) {
                String hostColonPort = this.getHostColonPort(fullyQualifiedServerUrl);
                this.cache.put(key, hostColonPort);
                return hostColonPort;
            }
            if ("requestContextPath".equals(key)) {
                String requestContextPath = PentahoRequestContextHolder.getRequestContext().getContextPath();
                this.cache.put(key, requestContextPath);
            } else if ("selfURL".equals(key)) {
                String path = this.getRepositoryPath(true);
                if (path != null) {
                    String selfURL = fullyQualifiedServerUrl + "api/repos/" + path + "/viewer?";
                    this.cache.put(key, selfURL);
                    return selfURL;
                }
                return null;
            }
        } else if ("serverBaseURL".equals(key) || "pentahoBaseURL".equals(key) || "solutionRoot".equals(key) || "hostColonPort".equals(key) || "requestContextPath".equals(key)) {
            logger.warn((Object)Messages.getInstance().getString("ReportPlugin.warnNoApplicationContext"));
            this.cache.put(key, null);
            return null;
        }
        if (session != null) {
            Object attribute;
            Authentication authentication;
            if ("username".equals(key)) {
                authentication = SecurityHelper.getInstance().getAuthentication();
                if (authentication == null) {
                    return null;
                }
                ITenantedPrincipleNameResolver tenantedUserNameUtils = (ITenantedPrincipleNameResolver)PentahoSystem.get(ITenantedPrincipleNameResolver.class, (String)"tenantedUserNameUtils", (IPentahoSession)session);
                String userName = null;
                userName = tenantedUserNameUtils != null ? tenantedUserNameUtils.getPrincipleName(authentication.getName()) : authentication.getName();
                this.cache.put(key, userName);
                return userName;
            }
            if ("roles".equals(key)) {
                authentication = SecurityHelper.getInstance().getAuthentication();
                if (authentication == null) {
                    return null;
                }
                StringBuilder property = new StringBuilder();
                Collection roles = authentication.getAuthorities();
                ITenantedPrincipleNameResolver tenantedRoleNameUtils = (ITenantedPrincipleNameResolver)PentahoSystem.get(ITenantedPrincipleNameResolver.class, (String)"tenantedRoleNameUtils", (IPentahoSession)session);
                if (roles == null) {
                    return null;
                }
                CSVQuoter quoter = new CSVQuoter(',', '\"');
                for (GrantedAuthority ga : roles) {
                    if (property.length() > 0) {
                        property.append(",");
                    }
                    String authority = null;
                    authority = tenantedRoleNameUtils != null ? tenantedRoleNameUtils.getPrincipleName(ga.getAuthority()) : ga.getAuthority();
                    property.append(quoter.doQuoting(authority));
                }
                return property.toString();
            }
            if (key.startsWith("session:")) {
                attribute = session.getAttribute(key.substring("session:".length()));
                return String.valueOf(attribute);
            }
            if (key.startsWith("global:")) {
                attribute = PentahoSystem.getGlobalParameters().getParameter(key.substring("global:".length()));
                return String.valueOf(attribute);
            }
        } else if (key.startsWith("session:") || key.equals("username") || key.startsWith("global:") || key.equals("roles")) {
            logger.warn((Object)Messages.getInstance().getString("ReportPlugin.warnNoSession"));
            return null;
        }
        if ((environmentProperty = super.getEnvironmentProperty(key)) == null) {
            return null;
        }
        return String.valueOf(environmentProperty);
    }

    private String getBaseServerURL(String fullyQualifiedServerUrl) {
        try {
            URL url = new URL(fullyQualifiedServerUrl);
            return url.getProtocol() + "://" + url.getHost() + ":" + url.getPort();
        }
        catch (Exception e) {
            logger.warn((Object)Messages.getInstance().getString("ReportPlugin.warnNoBaseServerURL"), (Throwable)e);
            return null;
        }
    }

    private String getHostColonPort(String fullyQualifiedServerUrl) {
        try {
            URL url = new URL(fullyQualifiedServerUrl);
            return url.getHost() + ":" + url.getPort();
        }
        catch (Exception e) {
            logger.warn((Object)Messages.getInstance().getString("ReportPlugin.warnNoHostColonPort"), (Throwable)e);
            return null;
        }
    }

    public String getRepositoryPath() {
        return this.getRepositoryPath(false);
    }

    private String getRepositoryPath(boolean encoded) {
        if (encoded) {
            return Encode.forUriComponent((String)this.repositoryPath);
        }
        return this.repositoryPath;
    }
}

