/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportGenerator;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.xml.sax.InputSource;

public class ReportCreator {
    public static MasterReport createReport(InputStream inputStream, URL url) throws IOException, ResourceException {
        ReportGenerator generator = ReportGenerator.createInstance();
        InputSource repDefInputSource = new InputSource(inputStream);
        return generator.parseReport(repDefInputSource, url);
    }

    public static MasterReport createReportByName(String fullFilePathAndName) throws ResourceException, IOException {
        IUnifiedRepository unifiedRepository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class, (IPentahoSession)PentahoSessionHolder.getSession());
        RepositoryFile repositoryFile = unifiedRepository.getFile(fullFilePathAndName);
        if (repositoryFile == null) {
            throw new IOException("File " + fullFilePathAndName + " not found in repository");
        }
        return ReportCreator.createReport(repositoryFile.getId());
    }

    public static MasterReport createReport(Serializable fileId) throws ResourceException, IOException {
        ResourceManager resourceManager = new ResourceManager();
        resourceManager.registerDefaults();
        HashMap helperObjects = new HashMap();
        ResourceKey key = null;
        IUnifiedRepository unifiedRepository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class, (IPentahoSession)PentahoSessionHolder.getSession());
        RepositoryFile repositoryFile = unifiedRepository.getFileById(fileId);
        key = repositoryFile != null ? resourceManager.createKey((Object)("pentaho2://" + repositoryFile.getPath()), helperObjects) : resourceManager.createKey((Object)("pentaho2://" + fileId), helperObjects);
        Resource resource = resourceManager.create(key, null, MasterReport.class);
        return (MasterReport)resource.getResource();
    }
}

