/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.platform.plugin.RepositoryResourceData;
import org.pentaho.reporting.platform.plugin.messages.Messages;

public class RepositoryResourceLoader
implements ResourceLoader {
    public static final String SOLUTION_SCHEMA_NAME = "pentaho2";
    public static final String SCHEMA_SEPARATOR = "://";
    public static final String PATH_SEPARATOR = "/";
    public static final String WIN_PATH_SEPARATOR = "\\";
    private ResourceManager manager;

    public void setResourceManager(ResourceManager manager) {
        this.manager = manager;
    }

    public ResourceManager getManager() {
        return this.manager;
    }

    public String getSchema() {
        return SOLUTION_SCHEMA_NAME;
    }

    public ResourceData load(ResourceKey key) throws ResourceLoadingException {
        return new RepositoryResourceData(key);
    }

    public boolean isSupportedKey(ResourceKey key) {
        return key.getSchema().equals(this.getSchema());
    }

    public ResourceKey createKey(Object value, Map factoryKeys) throws ResourceKeyCreationException {
        String valueString;
        if (value instanceof String && (valueString = (String)value).startsWith(this.getSchema() + SCHEMA_SEPARATOR)) {
            String path = valueString.substring(this.getSchema().length() + SCHEMA_SEPARATOR.length());
            return new ResourceKey((Object)this.getSchema(), (Object)path, factoryKeys);
        }
        return null;
    }

    public ResourceKey deriveKey(ResourceKey parent, String path, Map data) throws ResourceKeyCreationException {
        if (!path.startsWith(this.getSchema() + SCHEMA_SEPARATOR)) {
            int winindex = ((String)parent.getIdentifier()).lastIndexOf(WIN_PATH_SEPARATOR);
            int regindex = ((String)parent.getIdentifier()).lastIndexOf(PATH_SEPARATOR);
            int dirindex = 0;
            dirindex = winindex > regindex ? winindex + WIN_PATH_SEPARATOR.length() : regindex + PATH_SEPARATOR.length();
            path = ((String)parent.getIdentifier()).substring(0, dirindex) + path;
        }
        HashMap derivedValues = new HashMap(parent.getFactoryParameters());
        if (data != null) {
            derivedValues.putAll(data);
        }
        return new ResourceKey((Object)this.getSchema(), (Object)path, derivedValues);
    }

    public ResourceKey deserialize(ResourceKey bundleKey, String stringKey) throws ResourceKeyCreationException {
        throw new ResourceKeyCreationException(Messages.getInstance().getString("ReportPlugin.cannotDeserializeZipResourceKey"));
    }

    public String serialize(ResourceKey bundleKey, ResourceKey key) throws ResourceException {
        throw new ResourceKeyCreationException(Messages.getInstance().getString("ReportPlugin.cannotSerializeZipResourceKey"));
    }

    public URL toURL(ResourceKey key) {
        return null;
    }

    public boolean isSupportedDeserializer(String data) {
        return false;
    }
}

