/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.async;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.platform.plugin.AuditWrapper;
import org.pentaho.reporting.platform.plugin.SimpleReportingComponent;
import org.pentaho.reporting.platform.plugin.async.AsyncExecutionStatus;
import org.pentaho.reporting.platform.plugin.async.AsyncReportStatusListener;
import org.pentaho.reporting.platform.plugin.async.IAsyncReportExecution;
import org.pentaho.reporting.platform.plugin.async.IAsyncReportState;
import org.pentaho.reporting.platform.plugin.async.IListenableFutureDelegator;
import org.pentaho.reporting.platform.plugin.async.SimpleDelegatedListenableFuture;
import org.pentaho.reporting.platform.plugin.staging.AsyncJobFileStagingHandler;
import org.pentaho.reporting.platform.plugin.staging.IFixedSizeStreamingContent;

public abstract class AbstractAsyncReportExecution<TReportState extends IAsyncReportState>
implements IAsyncReportExecution<TReportState>,
IListenableFutureDelegator<IFixedSizeStreamingContent> {
    protected final SimpleReportingComponent reportComponent;
    protected final AsyncJobFileStagingHandler handler;
    protected final String url;
    protected final String auditId;
    protected final IPentahoSession safeSession;
    private AsyncReportStatusListener listener;
    private static final Log log = LogFactory.getLog(AbstractAsyncReportExecution.class);
    private AuditWrapper audit;
    public static final IFixedSizeStreamingContent NULL = new NullSizeStreamingContent();

    public AbstractAsyncReportExecution(String url, SimpleReportingComponent reportComponent, AsyncJobFileStagingHandler handler, IPentahoSession safeSession, String auditId) {
        this(url, reportComponent, handler, safeSession, auditId, AuditWrapper.NULL);
    }

    public AbstractAsyncReportExecution(String url, SimpleReportingComponent reportComponent, AsyncJobFileStagingHandler handler, IPentahoSession safeSession, String auditId, AuditWrapper audit) {
        ArgumentNullException.validate((String)"url", (Object)url);
        ArgumentNullException.validate((String)"reportComponent", (Object)reportComponent);
        ArgumentNullException.validate((String)"handler", (Object)handler);
        ArgumentNullException.validate((String)"safeSession", (Object)safeSession);
        ArgumentNullException.validate((String)"auditId", (Object)auditId);
        ArgumentNullException.validate((String)"audit", (Object)audit);
        this.reportComponent = reportComponent;
        this.handler = handler;
        this.url = url;
        this.auditId = auditId;
        this.safeSession = safeSession;
        this.audit = audit;
    }

    @Override
    public void notifyTaskQueued(UUID id, List<? extends ReportProgressListener> callbackListeners) {
        ArgumentNullException.validate((String)"id", (Object)id);
        if (this.listener != null) {
            throw new IllegalStateException("This instance has already been scheduled.");
        }
        this.listener = this.createListener(id, callbackListeners);
    }

    protected AsyncReportStatusListener getListener() {
        return this.listener;
    }

    protected AuditWrapper getAudit() {
        return this.audit;
    }

    protected void fail() {
        String messageType = "cancelled";
        if (this.listener != null && !this.listener.getState().getStatus().equals((Object)AsyncExecutionStatus.CANCELED)) {
            this.listener.setStatus(AsyncExecutionStatus.FAILED);
            messageType = "failed";
        }
        this.audit.audit(this.safeSession.getId(), this.safeSession.getName(), this.getAuditActionName(), this.getClass().getName(), this.getClass().getName(), messageType, this.auditId, "", 0.0f, null);
        this.closeFile();
    }

    private void closeFile() {
        try {
            this.handler.getStagingContent().cleanContent();
        }
        catch (Exception e) {
            log.debug((Object)"No content was created for this task");
        }
    }

    protected String getAuditActionName() {
        return this.url;
    }

    protected AsyncReportStatusListener createListener(UUID instanceId, List<? extends ReportProgressListener> callbackListeners) {
        return new AsyncReportStatusListener(this.getReportPath(), instanceId, this.getMimeType(), callbackListeners);
    }

    protected void cancel() {
        String userName = this.safeSession == null ? "Unknown" : this.safeSession.getName();
        log.info((Object)("Report execution canceled: " + this.url + " , requested by : " + userName));
        this.closeFile();
        if (this.listener != null) {
            this.listener.cancel();
        }
    }

    @Override
    public void requestPage(int page) {
        this.listener.setRequestedPage(page);
    }

    public String toString() {
        return "PentahoAsyncReportExecution{url='" + this.url + '\'' + ", instanceId='" + this.auditId + '\'' + ", listener=" + this.listener + '}';
    }

    @Override
    public String getMimeType() {
        return this.reportComponent.getMimeType();
    }

    @Override
    public String getReportPath() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean schedule() {
        AsyncReportStatusListener asyncReportStatusListener = this.listener;
        synchronized (asyncReportStatusListener) {
            if (this.listener.isScheduled()) {
                return false;
            }
            this.listener.setStatus(AsyncExecutionStatus.SCHEDULED);
            return this.listener.isScheduled();
        }
    }

    @Override
    public ListenableFuture<IFixedSizeStreamingContent> delegate(ListenableFuture<IFixedSizeStreamingContent> delegate) {
        return new CancelableListenableFuture(delegate);
    }

    @Override
    public boolean preSchedule() {
        this.listener.setStatus(AsyncExecutionStatus.PRE_SCHEDULED);
        return AsyncExecutionStatus.PRE_SCHEDULED.equals((Object)this.listener.getState().getStatus());
    }

    class CancelableListenableFuture
    extends SimpleDelegatedListenableFuture<IFixedSizeStreamingContent> {
        private CancelableListenableFuture(ListenableFuture<IFixedSizeStreamingContent> delegate) {
            super(delegate);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            AsyncReportStatusListener listener = AbstractAsyncReportExecution.this.getListener();
            if (!listener.isScheduled()) {
                try {
                    if (mayInterruptIfRunning) {
                        AbstractAsyncReportExecution.this.cancel();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return super.cancel(mayInterruptIfRunning);
            }
            return Boolean.FALSE;
        }
    }

    public static final class NullSizeStreamingContent
    implements IFixedSizeStreamingContent {
        @Override
        public InputStream getStream() {
            return new NullInputStream(0L);
        }

        @Override
        public long getContentSize() {
            return 0L;
        }

        @Override
        public boolean cleanContent() {
            return true;
        }
    }
}

