/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.async;

import com.google.common.util.concurrent.ForwardingListeningExecutorService;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.platform.plugin.async.IListenableFutureDelegator;

public class DelegatedListenableExecutor
extends ForwardingListeningExecutorService {
    private final ListeningExecutorService delegateExecutor;

    public DelegatedListenableExecutor(ExecutorService delegateExecutor) {
        ArgumentNullException.validate((String)"delegateExecutor", (Object)delegateExecutor);
        this.delegateExecutor = MoreExecutors.listeningDecorator((ExecutorService)delegateExecutor);
    }

    protected ListeningExecutorService delegate() {
        return this.delegateExecutor;
    }

    public <T> ListenableFuture<T> submit(Callable<T> callable) {
        if (callable instanceof IListenableFutureDelegator) {
            ListenableFuture delegateFuture = this.delegateExecutor.submit(callable);
            return ((IListenableFutureDelegator)((Object)callable)).delegate(delegateFuture);
        }
        return this.delegateExecutor.submit(callable);
    }
}

