/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.async;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.ILogoutListener;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.platform.plugin.async.AsyncExecutionStatus;
import org.pentaho.reporting.platform.plugin.async.AutoScheduleListener;
import org.pentaho.reporting.platform.plugin.async.DelegatedListenableExecutor;
import org.pentaho.reporting.platform.plugin.async.IAsyncReportExecution;
import org.pentaho.reporting.platform.plugin.async.IAsyncReportState;
import org.pentaho.reporting.platform.plugin.async.IPentahoAsyncExecutor;
import org.pentaho.reporting.platform.plugin.async.ISchedulingListener;
import org.pentaho.reporting.platform.plugin.async.MemorizeSchedulingLocationListener;
import org.pentaho.reporting.platform.plugin.async.PentahoAsyncReportExecution;
import org.pentaho.reporting.platform.plugin.async.UpdateSchedulingLocationListener;
import org.pentaho.reporting.platform.plugin.async.WriteToJcrTask;
import org.pentaho.reporting.platform.plugin.staging.AsyncJobFileStagingHandler;
import org.pentaho.reporting.platform.plugin.staging.IFixedSizeStreamingContent;

public class PentahoAsyncExecutor<TReportState extends IAsyncReportState>
implements ILogoutListener,
IPentahoAsyncExecutor<TReportState> {
    public static final String BEAN_NAME = "IPentahoAsyncExecutor";
    private static final Log log = LogFactory.getLog(PentahoAsyncExecutor.class);
    private Map<CompositeKey, ListenableFuture<IFixedSizeStreamingContent>> futures = new ConcurrentHashMap<CompositeKey, ListenableFuture<IFixedSizeStreamingContent>>();
    private Map<CompositeKey, IAsyncReportExecution<TReportState>> tasks = new ConcurrentHashMap<CompositeKey, IAsyncReportExecution<TReportState>>();
    private ListeningExecutorService executorService;
    private final int autoSchedulerThreshold;
    private final MemorizeSchedulingLocationListener schedulingLocationListener;
    private Map<CompositeKey, ISchedulingListener> writeToJcrListeners;

    public PentahoAsyncExecutor(int capacity, int autoSchedulerThreshold) {
        this.autoSchedulerThreshold = autoSchedulerThreshold;
        log.info((Object)("Initialized reporting async execution fixed thread pool with capacity: " + capacity));
        this.executorService = new DelegatedListenableExecutor(new ThreadPoolExecutor(capacity, capacity, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = Executors.defaultThreadFactory().newThread(r);
                thread.setDaemon(true);
                thread.setName("PentahoAsyncExecutor Thread Pool");
                return thread;
            }
        }));
        PentahoSystem.addLogoutListener((ILogoutListener)this);
        this.writeToJcrListeners = new ConcurrentHashMap<CompositeKey, ISchedulingListener>();
        this.schedulingLocationListener = new MemorizeSchedulingLocationListener();
    }

    @Deprecated
    public PentahoAsyncExecutor(int capacity) {
        this(capacity, 0);
    }

    @Override
    public UUID addTask(IAsyncReportExecution<TReportState> task, IPentahoSession session) {
        return this.addTask(task, session, UUID.randomUUID());
    }

    @Override
    public UUID addTask(IAsyncReportExecution<TReportState> task, IPentahoSession session, UUID id) {
        CompositeKey key = new CompositeKey(session, id);
        task.notifyTaskQueued(id, Collections.singletonList(new AutoScheduleListener(id, session, this.autoSchedulerThreshold, this)));
        log.debug((Object)("register async execution for task: " + task.toString()));
        ListenableFuture result = this.executorService.submit(task);
        this.futures.put(key, (ListenableFuture<IFixedSizeStreamingContent>)result);
        this.tasks.put(key, task);
        return id;
    }

    @Override
    public Future<IFixedSizeStreamingContent> getFuture(UUID id, IPentahoSession session) {
        this.validateParams(id, session);
        return (Future)this.futures.get(new CompositeKey(session, id));
    }

    @Override
    public void cleanFuture(UUID id, IPentahoSession session) {
        CompositeKey key = new CompositeKey(session, id);
        this.futures.remove(key);
        this.tasks.remove(key);
    }

    @Override
    public void requestPage(UUID id, IPentahoSession session, int page) {
        this.validateParams(id, session);
        IAsyncReportExecution<TReportState> runningTask = this.tasks.get(new CompositeKey(session, id));
        if (runningTask != null) {
            runningTask.requestPage(page);
        }
    }

    @Override
    public boolean preSchedule(UUID uuid, IPentahoSession session) {
        this.validateParams(uuid, session);
        CompositeKey compositeKey = new CompositeKey(session, uuid);
        IAsyncReportExecution<TReportState> runningTask = this.tasks.get(compositeKey);
        if (runningTask != null) {
            return runningTask.preSchedule();
        }
        return false;
    }

    @Override
    public UUID recalculate(UUID uuid, IPentahoSession session) {
        this.validateParams(uuid, session);
        CompositeKey compositeKey = new CompositeKey(session, uuid);
        IAsyncReportExecution<TReportState> runningTask = this.tasks.get(compositeKey);
        if (runningTask == null) {
            throw new IllegalStateException("We must have a task at this point.");
        }
        try {
            PentahoAsyncReportExecution recalcTask = new PentahoAsyncReportExecution((PentahoAsyncReportExecution)runningTask, new AsyncJobFileStagingHandler(session));
            return this.addTask(recalcTask, session);
        }
        catch (Exception e) {
            log.error((Object)"Can't recalculate task: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean schedule(UUID id, IPentahoSession session) {
        this.validateParams(id, session);
        CompositeKey compositeKey = new CompositeKey(session, id);
        IAsyncReportExecution<TReportState> runningTask = this.tasks.get(compositeKey);
        ListenableFuture<IFixedSizeStreamingContent> future = this.futures.get(compositeKey);
        if (runningTask == null || future == null) {
            throw new IllegalStateException("We must have a task and a future at this point.");
        }
        String userId = session.getName();
        String sessionId = session.getId();
        if (!StringUtils.isEmpty((String)userId) && runningTask.schedule()) {
            Futures.addCallback(future, (FutureCallback)new TriggerScheduledContentWritingHandler(userId, sessionId, runningTask, compositeKey), (Executor)this.executorService);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSchedulingLocation(UUID id, IPentahoSession session, Serializable folderId, String newName) {
        this.validateParams(id, session);
        CompositeKey key = new CompositeKey(session, id);
        IAsyncReportExecution<TReportState> runningTask = this.tasks.get(key);
        if (runningTask == null) {
            throw new IllegalStateException("We must have a task at this point.");
        }
        UpdateSchedulingLocationListener listener = this.getUpdateSchedulingLocationListener(folderId, newName);
        try {
            this.schedulingLocationListener.lock();
            Serializable fileId = this.schedulingLocationListener.lookupOutputFile(key);
            if (fileId != null) {
                listener.onSchedulingCompleted(fileId);
            } else {
                this.writeToJcrListeners.put(key, listener);
            }
        }
        finally {
            this.schedulingLocationListener.unlock();
        }
    }

    protected UpdateSchedulingLocationListener getUpdateSchedulingLocationListener(Serializable folderId, String newName) {
        return new UpdateSchedulingLocationListener(folderId, newName);
    }

    @Override
    public TReportState getReportState(UUID id, IPentahoSession session) {
        this.validateParams(id, session);
        IAsyncReportExecution<TReportState> runningTask = this.tasks.get(new CompositeKey(session, id));
        return runningTask == null ? null : (TReportState)runningTask.getState();
    }

    protected void validateParams(UUID id, IPentahoSession session) {
        ArgumentNullException.validate((String)"uuid", (Object)id);
        ArgumentNullException.validate((String)"session", (Object)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLogout(IPentahoSession session) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("killing async report execution cache for user: " + session.getName()));
        }
        for (Map.Entry<CompositeKey, ListenableFuture<IFixedSizeStreamingContent>> entry : this.futures.entrySet()) {
            if (!ObjectUtils.equals((Object)entry.getKey().getSessionId(), (Object)session.getId())) continue;
            IAsyncReportExecution<TReportState> task = this.tasks.get(entry.getKey());
            ListenableFuture<IFixedSizeStreamingContent> value = entry.getValue();
            if (task != null && task.getState() != null && AsyncExecutionStatus.SCHEDULED.equals((Object)task.getState().getStatus())) {
                this.tasks.remove(entry.getKey());
                continue;
            }
            value.cancel(true);
            this.futures.remove(entry.getKey());
            this.tasks.remove(entry.getKey());
        }
        try {
            this.schedulingLocationListener.lock();
            this.schedulingLocationListener.onLogout(session.getId());
        }
        finally {
            this.schedulingLocationListener.unlock();
        }
        AsyncJobFileStagingHandler.cleanSession(session);
    }

    @Override
    public void shutdown() {
        for (Future future : this.futures.values()) {
            future.cancel(true);
        }
        this.futures.clear();
        this.tasks.clear();
        this.writeToJcrListeners.clear();
        this.executorService.shutdown();
        try {
            this.schedulingLocationListener.lock();
            this.schedulingLocationListener.shutdown();
        }
        finally {
            this.schedulingLocationListener.unlock();
        }
        AsyncJobFileStagingHandler.cleanStagingDir();
    }

    protected Callable<Serializable> getWriteToJcrTask(IFixedSizeStreamingContent result, IAsyncReportExecution<? extends IAsyncReportState> runningTask) {
        return new WriteToJcrTask(runningTask, result.getStream());
    }

    class TriggerScheduledContentWritingHandler
    implements FutureCallback<IFixedSizeStreamingContent> {
        private final IAsyncReportExecution<TReportState> runningTask;
        private final CompositeKey compositeKey;
        private final String user;
        private final String sessionId;

        TriggerScheduledContentWritingHandler(String user, String sessionId, IAsyncReportExecution<TReportState> runningTask, CompositeKey compositeKey) {
            this.user = user;
            this.sessionId = sessionId;
            this.runningTask = runningTask;
            this.compositeKey = compositeKey;
        }

        protected IFixedSizeStreamingContent notifyListeners(IFixedSizeStreamingContent result) throws Exception {
            Serializable writtenTo = PentahoAsyncExecutor.this.getWriteToJcrTask(result, this.runningTask).call();
            if (writtenTo == null) {
                log.debug((Object)"Unable to move scheduled content, due to error while creating content in default location.");
                return null;
            }
            try {
                PentahoAsyncExecutor.this.schedulingLocationListener.lock();
                PentahoAsyncExecutor.this.schedulingLocationListener.recordOutputFile(this.compositeKey, writtenTo);
                this.notifyListeners(writtenTo);
            }
            finally {
                PentahoAsyncExecutor.this.schedulingLocationListener.unlock();
            }
            return null;
        }

        protected void notifyListeners(Serializable writtenTo) {
            ISchedulingListener iSchedulingListener = (ISchedulingListener)PentahoAsyncExecutor.this.writeToJcrListeners.get(this.compositeKey);
            if (iSchedulingListener != null) {
                iSchedulingListener.onSchedulingCompleted(writtenTo);
                PentahoAsyncExecutor.this.writeToJcrListeners.remove(this.compositeKey);
            }
        }

        public void onSuccess(IFixedSizeStreamingContent result) {
            try {
                if (this.user != null && !StringUtil.isEmpty((String)this.user)) {
                    SecurityHelper.getInstance().runAsUser(this.user, () -> this.notifyListeners(result));
                }
            }
            catch (Exception e) {
                log.error((Object)"Can't execute callback. : ", (Throwable)e);
            }
            finally {
                PentahoAsyncExecutor.this.futures.remove(this.compositeKey);
                result.cleanContent();
                AsyncJobFileStagingHandler.cleanSession(this.sessionId);
            }
        }

        public void onFailure(Throwable t) {
            log.error((Object)"Can't execute callback. Parent task failed: ", t);
            PentahoAsyncExecutor.this.futures.remove(this.compositeKey);
            AsyncJobFileStagingHandler.cleanSession(this.sessionId);
        }
    }

    public static class CompositeKey {
        private String sessionId;
        private String uuid;

        CompositeKey(IPentahoSession session, UUID id) {
            this.uuid = id.toString();
            this.sessionId = session.getId();
        }

        public boolean isSameSession(String sessionId) {
            return StringUtils.equals((String)sessionId, (String)this.sessionId);
        }

        private String getSessionId() {
            return this.sessionId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompositeKey that = (CompositeKey)o;
            return Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.uuid, that.uuid);
        }

        public int hashCode() {
            return Objects.hash(this.sessionId, this.uuid);
        }
    }
}

