/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.async;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.platform.plugin.AuditWrapper;
import org.pentaho.reporting.platform.plugin.ReportCreator;
import org.pentaho.reporting.platform.plugin.SimpleReportingComponent;
import org.pentaho.reporting.platform.plugin.async.AbstractAsyncReportExecution;
import org.pentaho.reporting.platform.plugin.async.AsyncExecutionStatus;
import org.pentaho.reporting.platform.plugin.async.AsyncReportStatusListener;
import org.pentaho.reporting.platform.plugin.async.IAsyncReportState;
import org.pentaho.reporting.platform.plugin.async.ReportListenerThreadHolder;
import org.pentaho.reporting.platform.plugin.staging.AsyncJobFileStagingHandler;
import org.pentaho.reporting.platform.plugin.staging.IFixedSizeStreamingContent;

public class PentahoAsyncReportExecution
extends AbstractAsyncReportExecution<IAsyncReportState> {
    private static final Log log = LogFactory.getLog(PentahoAsyncReportExecution.class);

    public PentahoAsyncReportExecution(String url, SimpleReportingComponent reportComponent, AsyncJobFileStagingHandler handler, IPentahoSession safeSession, String auditId, AuditWrapper audit) {
        super(url, reportComponent, handler, safeSession, auditId, audit);
    }

    PentahoAsyncReportExecution(PentahoAsyncReportExecution old, AsyncJobFileStagingHandler handler) {
        super(old.url, old.reportComponent, handler, old.safeSession, old.auditId, old.getAudit());
        old.reportComponent.setOutputStream(handler.getStagingOutputStream());
        MasterReport report = this.getReport(old);
        if (report != null) {
            old.reportComponent.setReport(report);
        }
    }

    private MasterReport getReport(PentahoAsyncReportExecution old) {
        String path = old.getState().getPath();
        try {
            return ReportCreator.createReportByName(path);
        }
        catch (IOException | ResourceException e) {
            log.error((Object)"No report was found on provided path", e);
            return null;
        }
    }

    @Override
    public IFixedSizeStreamingContent call() throws Exception {
        final AsyncReportStatusListener listener = this.getListener();
        if (listener == null) {
            throw new NullPointerException("No listener for async report execution: " + this.url);
        }
        return (IFixedSizeStreamingContent)SecurityHelper.getInstance().runAsUser(this.safeSession.getName(), (Callable)new Callable<IFixedSizeStreamingContent>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IFixedSizeStreamingContent call() throws Exception {
                try {
                    listener.setStatus(AsyncExecutionStatus.WORKING);
                    PentahoSessionHolder.setSession((IPentahoSession)PentahoAsyncReportExecution.this.safeSession);
                    ReportListenerThreadHolder.setListener(listener);
                    ReportListenerThreadHolder.setRequestId(PentahoAsyncReportExecution.this.auditId);
                    long start = System.currentTimeMillis();
                    PentahoAsyncReportExecution.this.getAudit().audit(PentahoAsyncReportExecution.this.safeSession.getId(), PentahoAsyncReportExecution.this.safeSession.getName(), PentahoAsyncReportExecution.this.url, this.getClass().getName(), this.getClass().getName(), "instance_start", PentahoAsyncReportExecution.this.auditId, "", 0.0f, null);
                    if (PentahoAsyncReportExecution.this.reportComponent.execute()) {
                        long end = System.currentTimeMillis();
                        PentahoAsyncReportExecution.this.getAudit().audit(PentahoAsyncReportExecution.this.safeSession.getId(), PentahoAsyncReportExecution.this.safeSession.getName(), PentahoAsyncReportExecution.this.url, this.getClass().getName(), this.getClass().getName(), "instance_end", PentahoAsyncReportExecution.this.auditId, "", (float)(end - start) / 1000.0f, null);
                        IFixedSizeStreamingContent stagingContent = PentahoAsyncReportExecution.this.handler.getStagingContent();
                        listener.setStatus(AsyncExecutionStatus.FINISHED);
                        IFixedSizeStreamingContent iFixedSizeStreamingContent = stagingContent;
                        return iFixedSizeStreamingContent;
                    }
                    PentahoAsyncReportExecution.this.fail();
                    IFixedSizeStreamingContent end = AbstractAsyncReportExecution.NULL;
                    return end;
                }
                catch (Throwable ee) {
                    log.error((Object)("fail to execute report in async mode: " + ee));
                    if (ee.getMessage() != null) {
                        String errorMessage = "";
                        for (Throwable throwable = ee; throwable != null; throwable = throwable.getCause()) {
                            errorMessage = errorMessage + throwable.getMessage() + ".\n";
                        }
                        listener.setErrorMessage(errorMessage);
                    }
                    PentahoAsyncReportExecution.this.fail();
                    IFixedSizeStreamingContent iFixedSizeStreamingContent = AbstractAsyncReportExecution.NULL;
                    return iFixedSizeStreamingContent;
                }
                finally {
                    OutputStream out = PentahoAsyncReportExecution.this.handler.getStagingOutputStream();
                    IOUtils.closeQuietly((OutputStream)out);
                    ReportListenerThreadHolder.clear();
                    PentahoSessionHolder.removeSession();
                }
            }
        });
    }

    @Override
    public String toString() {
        return "PentahoAsyncReportExecution{url='" + this.url + '\'' + ", instanceId='" + this.auditId + '\'' + ", listener=" + this.getListener() + '}';
    }

    @Override
    public IAsyncReportState getState() {
        AsyncReportStatusListener listener = this.getListener();
        if (listener == null) {
            throw new IllegalStateException("Cannot query state until job is added to the executor.");
        }
        return listener.getState();
    }
}

