/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.async;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;

public abstract class SimpleDelegatedListenableFuture<T>
implements ListenableFuture<T> {
    private ListenableFuture<T> delegate;
    private AtomicBoolean canceled = new AtomicBoolean(false);

    public SimpleDelegatedListenableFuture(ListenableFuture<T> delegate) {
        ArgumentNullException.validate((String)"delegate", delegate);
        this.delegate = delegate;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.canceled.compareAndSet(false, true);
    }

    public boolean isCancelled() {
        return this.canceled.get();
    }

    public boolean isDone() {
        return this.delegate.isDone();
    }

    public T get() throws InterruptedException, ExecutionException {
        return (T)this.delegate.get();
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.delegate.get(timeout, unit);
    }

    public void addListener(Runnable listener, Executor executor) {
        this.delegate.addListener(listener, executor);
    }
}

