/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.async;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.platform.util.UUIDUtil;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.platform.plugin.async.ISchedulingListener;

class UpdateSchedulingLocationListener
implements ISchedulingListener {
    private static final String TARGET_LOCATION = "targetLocation";
    private static final String MOVE_MSG = "Moved to the location selected by user";
    private static final String ERROR_MSG = "Can't move report to selected location: ";
    private static final String NEW_NAME = "newName";
    private static Log log = LogFactory.getLog(UpdateSchedulingLocationListener.class);
    private static final String FORMAT = "%s(%d)%s";
    private final Serializable targetfolderId;
    private final String newName;

    UpdateSchedulingLocationListener(Serializable targetfolderId, String newName) {
        ArgumentNullException.validate((String)NEW_NAME, (Object)newName);
        ArgumentNullException.validate((String)TARGET_LOCATION, (Object)targetfolderId);
        this.newName = newName;
        this.targetfolderId = targetfolderId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onSchedulingCompleted(Serializable fileId) {
        try {
            IUnifiedRepository repo = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
            RepositoryFile savedFile = repo.getFileById(fileId);
            RepositoryFile outputFolder = repo.getFileById(this.targetfolderId);
            IOUtils utils = IOUtils.getInstance();
            if (savedFile == null || savedFile.isFolder() || outputFolder == null || !outputFolder.isFolder() || StringUtil.isEmpty((String)this.newName)) return;
            String fileExtension = utils.getFileExtension(savedFile.getName());
            String folderPath = outputFolder.getPath() + "/";
            String newPath = folderPath + this.newName + fileExtension;
            int count = 1;
            String string = FORMAT;
            synchronized (FORMAT) {
                String uuidAsString = this.getUuidAsString();
                while (null != repo.getFile(newPath + uuidAsString)) {
                    uuidAsString = this.getUuidAsString();
                }
                repo.moveFile(savedFile.getId(), newPath + uuidAsString, MOVE_MSG);
                while (null != repo.getFile(newPath)) {
                    newPath = String.format(FORMAT, folderPath + this.newName, count, fileExtension);
                    ++count;
                }
                repo.moveFile(savedFile.getId(), newPath, MOVE_MSG);
                // ** MonitorExit[var10_11] (shouldn't be in output)
                return;
            }
        }
        catch (Exception e) {
            log.error((Object)ERROR_MSG, (Throwable)e);
        }
    }

    protected String getUuidAsString() {
        return UUIDUtil.getUUIDAsString();
    }
}

