/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.async;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.platform.util.web.MimeHelper;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.platform.plugin.async.IAsyncReportExecution;
import org.pentaho.reporting.platform.plugin.async.IAsyncReportState;
import org.pentaho.reporting.platform.plugin.async.ISchedulingDirectoryStrategy;
import org.pentaho.reporting.platform.plugin.repository.ReportContentRepository;

public class WriteToJcrTask
implements Callable<Serializable> {
    private static final String CANT_CREATE_FILE_IN_JCR = "Can't create file in JCR";
    private static Log log = LogFactory.getLog(WriteToJcrTask.class);
    private static final String FORMAT = "%s(%d)%s";
    private static final String TXT = ".txt";
    private static final String DEFAULT_NAME = "content";
    private static final String CANT_PERSIST_MSG = "Cant't persist report: ";
    private final IAsyncReportExecution<? extends IAsyncReportState> parentTask;
    private final InputStream inputStream;

    public WriteToJcrTask(IAsyncReportExecution<? extends IAsyncReportState> parentTask, InputStream inputStream) {
        this.parentTask = parentTask;
        this.inputStream = inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Serializable call() throws Exception {
        try {
            IUnifiedRepository repo = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
            IOUtils utils = IOUtils.getInstance();
            ISchedulingDirectoryStrategy directoryStrategy = (ISchedulingDirectoryStrategy)PentahoSystem.get(ISchedulingDirectoryStrategy.class);
            RepositoryFile outputFolder = directoryStrategy.getSchedulingDir(repo);
            ReportContentRepository repository = this.getReportContentRepository(outputFolder);
            ContentLocation dataLocation = repository.getRoot();
            IAsyncReportState state = this.parentTask.getState();
            String extension = MimeHelper.getExtension((String)state.getMimeType());
            String targetExt = extension != null ? extension : TXT;
            String fullPath = state.getPath();
            String cleanFileName = utils.stripFileExtension(utils.getFileName(fullPath));
            if (StringUtil.isEmpty((String)cleanFileName)) {
                cleanFileName = DEFAULT_NAME;
            }
            String targetName = cleanFileName + targetExt;
            int copy = 1;
            String string = FORMAT;
            synchronized (FORMAT) {
                Serializable serializable;
                while (dataLocation.exists(targetName)) {
                    targetName = String.format(FORMAT, cleanFileName, copy, targetExt);
                    ++copy;
                }
                OutputStream outputStream = dataLocation.createItem(targetName).getOutputStream();
                // ** MonitorExit[var15_15] (shouldn't be in output)
                if (outputStream == null) throw new IOException(CANT_CREATE_FILE_IN_JCR);
                try {
                    org.apache.commons.io.IOUtils.copy((InputStream)this.inputStream, (OutputStream)outputStream);
                    outputStream.flush();
                    RepositoryFile targetFile = repo.getFile(outputFolder.getPath() + "/" + targetName);
                    serializable = targetFile.getId();
                }
                catch (Throwable throwable) {
                    try {
                        org.apache.commons.io.IOUtils.closeQuietly((OutputStream)outputStream);
                        throw throwable;
                    }
                    catch (Exception e) {
                        log.error((Object)CANT_PERSIST_MSG, (Throwable)e);
                        return null;
                    }
                }
                org.apache.commons.io.IOUtils.closeQuietly((OutputStream)outputStream);
                return serializable;
            }
        }
        finally {
            org.apache.commons.io.IOUtils.closeQuietly((InputStream)this.inputStream);
        }
    }

    protected ReportContentRepository getReportContentRepository(RepositoryFile outputFolder) {
        return new ReportContentRepository(outputFolder);
    }
}

