/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.cache;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.ILogoutListener;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.platform.plugin.cache.ReportCache;
import org.pentaho.reporting.platform.plugin.cache.ReportCacheKey;
import org.pentaho.reporting.platform.plugin.output.ReportOutputHandler;

public class DefaultReportCache
implements ReportCache {
    private static String SESSION_ATTRIBUTE = DefaultReportCache.class.getName() + "-Cache";
    private static String LISTENER_ADDED_ATTRIBUTE = DefaultReportCache.class.getName() + "-ListenerAdded";
    private static final String CACHE_NAME = "report-output-handlers";
    private static final Log logger = LogFactory.getLog(DefaultReportCache.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultReportCache() {
        IPentahoSession session;
        IPentahoSession iPentahoSession = session = PentahoSessionHolder.getSession();
        synchronized (iPentahoSession) {
            if (Boolean.TRUE.equals(session.getAttribute(LISTENER_ADDED_ATTRIBUTE))) {
                return;
            }
            PentahoSystem.addLogoutListener((ILogoutListener)new LogoutHandler());
            session.setAttribute(LISTENER_ADDED_ATTRIBUTE, (Object)Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReportOutputHandler get(ReportCacheKey key) {
        if (key.getSessionId() == null) {
            return null;
        }
        IPentahoSession session = PentahoSessionHolder.getSession();
        logger.debug((Object)("id: " + session.getId() + " - Cache.get(..) started"));
        IPentahoSession iPentahoSession = session;
        synchronized (iPentahoSession) {
            Object attribute = session.getAttribute(SESSION_ATTRIBUTE);
            if (!(attribute instanceof CacheManager)) {
                logger.debug((Object)("id: " + session.getId() + " - Cache.get(..): No cache manager"));
                return null;
            }
            CacheManager manager = (CacheManager)attribute;
            if (!manager.cacheExists(CACHE_NAME)) {
                logger.debug((Object)("id: " + session.getId() + " - Cache.get(..): No cache registered"));
                return null;
            }
            Cache cache = manager.getCache(CACHE_NAME);
            Element element = cache.get((Serializable)((Object)key.getSessionId()));
            if (element == null) {
                logger.debug((Object)("id: " + session.getId() + " - Cache.get(..): No element in cache for key: " + key.getSessionId()));
                return null;
            }
            Object o = element.getObjectValue();
            if (!(o instanceof CacheHolder)) {
                logger.debug((Object)("id: " + session.getId() + " - Cache.get(..): No valid element in cache for key: " + key.getSessionId()));
                return null;
            }
            CacheHolder cacheHolder = (CacheHolder)o;
            if (!cacheHolder.getRealKey().equals((Object)key)) {
                logger.debug((Object)("id: " + session.getId() + " - Cache.get(..): remove stale report after parameter changed: " + key.getSessionId()));
                cache.remove((Serializable)((Object)key.getSessionId()));
                return null;
            }
            logger.debug((Object)("id: " + session.getId() + " - Cache.get(..): Returning cached instance for key: " + key.getSessionId()));
            return new CachedReportOutputHandler(cacheHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReportOutputHandler put(ReportCacheKey key, ReportOutputHandler report) {
        if (key.getSessionId() == null) {
            return report;
        }
        if (report instanceof CachedReportOutputHandler) {
            throw new IllegalStateException();
        }
        IPentahoSession session = PentahoSessionHolder.getSession();
        logger.debug((Object)("id: " + session.getId() + " - Cache.put(..) started"));
        IPentahoSession iPentahoSession = session;
        synchronized (iPentahoSession) {
            Object o;
            Element element;
            Cache cache;
            CacheManager manager;
            Object attribute = session.getAttribute(SESSION_ATTRIBUTE);
            if (!(attribute instanceof CacheManager)) {
                logger.debug((Object)("id: " + session.getId() + " - Cache.put(..): No cache manager; creating one"));
                manager = CacheManager.create();
                session.setAttribute(SESSION_ATTRIBUTE, (Object)manager);
            } else {
                manager = (CacheManager)attribute;
            }
            if (!manager.cacheExists(CACHE_NAME)) {
                logger.debug((Object)("id: " + session.getId() + " - Cache.put(..): No cache registered with manager; creating one"));
                manager.addCache(CACHE_NAME);
                cache = manager.getCache(CACHE_NAME);
                cache.getCacheEventNotificationService().registerListener((CacheEventListener)new CacheEvictionHandler());
            }
            if ((element = (cache = manager.getCache(CACHE_NAME)).get((Serializable)((Object)key.getSessionId()))) != null && (o = element.getObjectValue()) instanceof CacheHolder) {
                CacheHolder cacheHolder = (CacheHolder)o;
                if (!cacheHolder.getRealKey().equals((Object)key)) {
                    logger.debug((Object)("id: " + session.getId() + " - Cache.put(..): Removing stale object."));
                    cache.remove((Serializable)((Object)key.getSessionId()));
                } else {
                    logger.debug((Object)("id: " + session.getId() + " - Cache.put(..): keeping existing object, no cache operation done."));
                    return new CachedReportOutputHandler(cacheHolder);
                }
            }
            CacheHolder cacheHolder = new CacheHolder(key, report);
            cache.put(new Element((Object)key.getSessionId(), (Object)cacheHolder));
            logger.debug((Object)("id: " + session.getId() + " - Cache.put(..): storing new report for key " + key.getSessionId()));
            return new CachedReportOutputHandler(cacheHolder);
        }
    }

    private static class CachedReportOutputHandler
    implements ReportOutputHandler {
        private CacheHolder parent;

        private CachedReportOutputHandler(CacheHolder parent) {
            this.parent = parent;
            this.parent.setReportInUse(true);
        }

        @Override
        public int paginate(MasterReport report, int yieldRate) throws ReportProcessingException, IOException, ContentIOException {
            return this.parent.getOutputHandler().paginate(report, yieldRate);
        }

        @Override
        public int generate(MasterReport report, int acceptedPage, OutputStream outputStream, int yieldRate) throws ReportProcessingException, IOException, ContentIOException {
            return this.parent.getOutputHandler().generate(report, acceptedPage, outputStream, yieldRate);
        }

        @Override
        public boolean supportsPagination() {
            return this.parent.getOutputHandler().supportsPagination();
        }

        @Override
        public void close() {
            this.parent.setReportInUse(false);
            if (!this.parent.isReportInCache()) {
                this.parent.close();
            }
        }

        @Override
        public Object getReportLock() {
            return this.parent.getOutputHandler().getReportLock();
        }
    }

    private static class CacheEvictionHandler
    implements CacheEventListener {
        private CacheEvictionHandler() {
        }

        public void notifyElementRemoved(Ehcache ehcache, Element element) throws CacheException {
            Object o = element.getObjectValue();
            if (!(o instanceof CacheHolder)) {
                return;
            }
            CacheHolder cacheHolder = (CacheHolder)o;
            cacheHolder.close();
        }

        public void notifyElementPut(Ehcache ehcache, Element element) throws CacheException {
        }

        public void notifyElementUpdated(Ehcache ehcache, Element element) throws CacheException {
        }

        public void notifyElementExpired(Ehcache ehcache, Element element) {
            Object o = element.getObjectValue();
            if (!(o instanceof CacheHolder)) {
                return;
            }
            CacheHolder cacheHolder = (CacheHolder)o;
            logger.debug((Object)("Shutting down report on element-expired event " + cacheHolder.getRealKey().getSessionId()));
            cacheHolder.close();
        }

        public void notifyElementEvicted(Ehcache ehcache, Element element) {
            Object o = element.getObjectValue();
            if (!(o instanceof CacheHolder)) {
                return;
            }
            CacheHolder cacheHolder = (CacheHolder)o;
            cacheHolder.markEvicted();
            logger.debug((Object)("Shutting down report on element-evicted event " + cacheHolder.getRealKey().getSessionId()));
            cacheHolder.close();
        }

        public void notifyRemoveAll(Ehcache ehcache) {
            ArrayList keys = new ArrayList(ehcache.getKeys());
            for (Object key : keys) {
                Element element = ehcache.get(key);
                Serializable o = element.getValue();
                if (!(o instanceof CacheHolder)) continue;
                CacheHolder cacheHolder = (CacheHolder)((Object)o);
                cacheHolder.markEvicted();
                logger.debug((Object)("Shutting down report on remove-all event " + cacheHolder.getRealKey().getSessionId()));
                cacheHolder.close();
            }
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public void dispose() {
        }
    }

    private static class CacheHolder {
        private ReportCacheKey realKey;
        private ReportOutputHandler outputHandler;
        private boolean closed;
        private boolean reportInUse;
        private boolean reportInCache;

        private CacheHolder(ReportCacheKey realKey, ReportOutputHandler outputHandler) {
            if (outputHandler == null) {
                throw new NullPointerException();
            }
            if (realKey == null) {
                throw new NullPointerException();
            }
            this.reportInCache = true;
            this.realKey = realKey;
            this.outputHandler = outputHandler;
        }

        public synchronized void markEvicted() {
            this.reportInCache = false;
        }

        public boolean isReportInCache() {
            return this.reportInCache;
        }

        public ReportCacheKey getRealKey() {
            return this.realKey;
        }

        public ReportOutputHandler getOutputHandler() {
            return this.outputHandler;
        }

        public synchronized void close() {
            if (this.reportInUse && this.reportInCache) {
                return;
            }
            if (!this.closed) {
                this.outputHandler.close();
                this.closed = true;
            }
        }

        public synchronized void setReportInUse(boolean reportInUse) {
            this.reportInUse = reportInUse;
        }
    }

    private static class LogoutHandler
    implements ILogoutListener {
        private LogoutHandler() {
        }

        public void onLogout(IPentahoSession session) {
            logger.debug((Object)("Shutting down session " + session.getId()));
            Object attribute = session.getAttribute(SESSION_ATTRIBUTE);
            if (!(attribute instanceof CacheManager)) {
                logger.debug((Object)("Shutting down session " + session.getId() + ": No cache manager found"));
                return;
            }
            CacheManager manager = (CacheManager)attribute;
            if (manager.cacheExists(DefaultReportCache.CACHE_NAME)) {
                Cache cache = manager.getCache(DefaultReportCache.CACHE_NAME);
                ArrayList keys = new ArrayList(cache.getKeys());
                logger.debug((Object)("Shutting down session " + session.getId() + ": Closing " + keys.size() + " open reports."));
                for (Object key : keys) {
                    cache.remove(key);
                }
            }
            logger.debug((Object)("Shutting down session " + session.getId() + ": Closing cache manager."));
            manager.shutdown();
        }
    }
}

