/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.platform.plugin.cache.BiPredicate;
import org.pentaho.reporting.platform.plugin.cache.ICacheBackend;

public class FileSystemCacheBackend
implements ICacheBackend {
    private static final Log logger = LogFactory.getLog(FileSystemCacheBackend.class);
    public static final String REPLACEMENT = "_";
    public static final String SLASHES = "[/\\\\]+";
    public static final String EXT = "\\.metadata|\\.data";
    public static final String DATA = ".data";
    public static final String METADATA = ".metadata";
    private final Map<List<String>, ReentrantReadWriteLock> syncMap = new HashMap<List<String>, ReentrantReadWriteLock>();
    private String cachePath;

    public void setCachePath(String cachePath) {
        this.cachePath = this.getSystemTmp() + cachePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(List<String> key, Serializable value, Map<String, Serializable> metaData) {
        List<String> cleanKey = FileSystemCacheBackend.sanitizeKeySegments(key);
        List<Lock> locks = this.lockForWrite(cleanKey);
        try {
            String filePath = this.cachePath + StringUtils.join(cleanKey, (String)File.separator);
            if (this.writeFile(value, filePath + DATA)) {
                boolean bl = false;
                return bl;
            }
            HashMap<String, Serializable> writeableMetaData = new HashMap<String, Serializable>();
            if (metaData != null) {
                writeableMetaData.putAll(metaData);
            }
            if (this.writeFile(writeableMetaData, filePath + METADATA)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock(locks);
        }
    }

    private boolean writeFile(Serializable value, String filePath) {
        File file = new File(filePath);
        try {
            file.getParentFile().mkdirs();
            if (!file.exists()) {
                file.createNewFile();
            }
            try (FileOutputStream fout = new FileOutputStream(file);
                 ObjectOutputStream oos = new ObjectOutputStream(fout);){
                oos.writeObject(value);
            }
        }
        catch (IOException e) {
            logger.error((Object)"Can't write cache: ", (Throwable)e);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable read(List<String> key) {
        Object result = null;
        List<String> cleanKey = FileSystemCacheBackend.sanitizeKeySegments(key);
        List<Lock> locks = this.lockForRead(cleanKey);
        try {
            String filePath = this.cachePath + StringUtils.join(cleanKey, (String)File.separator) + DATA;
            File f = new File(filePath);
            if (!f.exists()) {
                Serializable serializable = null;
                return serializable;
            }
            try (FileInputStream fis = new FileInputStream(f);
                 ObjectInputStream ois = new ObjectInputStream(fis);){
                result = ois.readObject();
            }
            catch (Exception e) {
                logger.debug((Object)"Can't read cache: ", (Throwable)e);
            }
            Serializable serializable = (Serializable)result;
            return serializable;
        }
        finally {
            this.unlock(locks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Serializable> readMetaData(List<String> key) {
        Object result = null;
        List<String> cleanKey = FileSystemCacheBackend.sanitizeKeySegments(key);
        ArrayList<String> noExtCleanKey = new ArrayList<String>(cleanKey.size());
        for (String cleanSegment : cleanKey) {
            noExtCleanKey.add(cleanSegment.replaceAll(EXT, ""));
        }
        List<Lock> locks = this.lockForRead(noExtCleanKey);
        try {
            Map map;
            String filePath = this.cachePath + StringUtils.join(noExtCleanKey, (String)File.separator) + METADATA;
            File f = new File(filePath);
            if (!f.exists()) {
                Map<String, Serializable> map2 = null;
                return map2;
            }
            try (FileInputStream fis = new FileInputStream(f);
                 ObjectInputStream ois = new ObjectInputStream(fis);){
                result = ois.readObject();
            }
            catch (Exception e) {
                logger.debug((Object)"Can't read cache: ", (Throwable)e);
            }
            if (result instanceof Map) {
                map = (Map)result;
                return map;
            }
            map = null;
            return map;
        }
        finally {
            this.unlock(locks);
        }
    }

    private void unlock(List<Lock> locks) {
        for (int i = locks.size() - 1; i >= 0; --i) {
            Lock lock = locks.get(i);
            lock.unlock();
        }
    }

    private List<Lock> lockForRead(List<String> key) {
        List<Object> retval;
        if (!key.isEmpty()) {
            List<String> parent = key.subList(0, key.size() - 1);
            retval = this.lockForRead(parent);
        } else {
            retval = new ArrayList();
        }
        ReentrantReadWriteLock.ReadLock lock = this.getLock(key).readLock();
        lock.lock();
        retval.add(lock);
        return retval;
    }

    private List<Lock> lockForWrite(List<String> key) {
        List<Object> retval;
        if (CollectionUtils.isNotEmpty(key)) {
            List<String> parent = key.subList(0, key.size() - 1);
            retval = this.lockForRead(parent);
        } else {
            retval = new ArrayList();
        }
        ReentrantReadWriteLock.WriteLock lock = this.getLock(key).writeLock();
        lock.lock();
        retval.add(lock);
        return retval;
    }

    private synchronized ReentrantReadWriteLock getLock(List<String> key) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        if (!this.syncMap.containsKey(key)) {
            this.syncMap.put(key, lock);
            return lock;
        }
        return this.syncMap.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeSegment(List<String> key, BiPredicate<List<String>, Map<String, Serializable>> p) {
        List<String> cleanKey = FileSystemCacheBackend.sanitizeKeySegments(key);
        List<Lock> locks = this.lockForWrite(cleanKey);
        try {
            ArrayList<String> entryKey;
            for (String name : this.listKeys(cleanKey)) {
                entryKey = new ArrayList<String>(cleanKey);
                entryKey.add(name);
                Map<String, Serializable> metaData = this.readMetaData(entryKey);
                if (!p.test(entryKey, metaData)) continue;
                this.purge(entryKey);
            }
            for (String name : this.listSegments(cleanKey)) {
                entryKey = new ArrayList<String>(cleanKey);
                entryKey.add(name);
                this.purgeSegment(entryKey, p);
            }
        }
        finally {
            this.unlock(locks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean purge(List<String> key) {
        List<String> cleanKey = FileSystemCacheBackend.sanitizeKeySegments(key);
        List<Lock> locks = this.lockForWrite(cleanKey);
        try {
            String fileName = this.cachePath + StringUtils.join(cleanKey, (String)File.separator);
            if (fileName.endsWith(DATA)) {
                File data = new File(fileName);
                if (!data.exists()) {
                    boolean bl = true;
                    return bl;
                }
                File meta = new File(fileName.replace(DATA, METADATA));
                this.syncMap.remove(cleanKey);
                boolean bl = data.delete() && meta.delete();
                return bl;
            }
            File file = new File(fileName);
            if (file.isDirectory()) {
                Set<String> subKeys = this.listKeys(cleanKey);
                for (String subKey : subKeys) {
                    ArrayList<String> subEntry = new ArrayList<String>(cleanKey);
                    subEntry.add(subKey);
                    this.purge(subEntry);
                }
                this.syncMap.remove(cleanKey);
                FileUtils.deleteDirectory((File)file);
                boolean bl = !file.exists();
                return bl;
            }
            File data = new File(fileName + DATA);
            if (!file.exists() && !data.exists()) {
                boolean bl = true;
                return bl;
            }
            File metadata = new File(fileName + METADATA);
            this.syncMap.remove(cleanKey);
            boolean bl = data.delete() && metadata.delete();
            return bl;
        }
        catch (Exception e) {
            logger.debug((Object)"Can't delete cache: ", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock(locks);
        }
    }

    private Set<String> listKeys(List<String> unsafeKey) {
        List<String> sanitized = FileSystemCacheBackend.sanitizeKeySegments(unsafeKey);
        HashSet<String> resultSet = new HashSet<String>();
        File directory = new File(this.cachePath + StringUtils.join(sanitized, (String)File.separator));
        File[] fList = directory.listFiles();
        if (fList != null) {
            for (File file : fList) {
                String name = file.getName();
                if (!file.isFile() || !name.endsWith(DATA)) continue;
                resultSet.add(IOUtils.getInstance().getFileName(name));
            }
        }
        return resultSet;
    }

    private Set<String> listSegments(List<String> unsafeKey) {
        List<String> sanitized = FileSystemCacheBackend.sanitizeKeySegments(unsafeKey);
        HashSet<String> resultSet = new HashSet<String>();
        File directory = new File(this.cachePath + StringUtils.join(sanitized, (String)File.separator));
        File[] fList = directory.listFiles();
        if (fList != null) {
            for (File file : fList) {
                if (!file.isDirectory()) continue;
                resultSet.add(file.getName());
            }
        }
        return resultSet;
    }

    String getSystemTmp() {
        String s = System.getProperty("java.io.tmpdir");
        char c = s.charAt(s.length() - 1);
        if (c != '/' && c != '\\') {
            s = s + File.separator;
            System.setProperty("java.io.tmpdir", s);
        }
        return s;
    }

    private static List<String> sanitizeKeySegments(List<String> key) {
        ArrayList<String> clean = new ArrayList<String>();
        if (key != null) {
            for (String segment : key) {
                clean.add(segment.replaceAll(SLASHES, REPLACEMENT));
            }
        }
        return clean;
    }
}

