/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.cache;

import java.util.Set;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.ILogoutListener;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.cache.CachableTableModel;
import org.pentaho.reporting.engine.classic.core.cache.DataCache;
import org.pentaho.reporting.engine.classic.core.cache.DataCacheKey;
import org.pentaho.reporting.engine.classic.core.cache.DataCacheManager;

public class PentahoDataCache
implements DataCache,
ILogoutListener {
    private static final Log log = LogFactory.getLog(PentahoDataCache.class);
    private static final String CACHE_NAME = "report-dataset-cache";
    private PentahoDataCacheManager manager;
    private ICacheManager cacheManager;
    private int maximumRows;

    public PentahoDataCache() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing");
        }
        this.maximumRows = ClassicEngineBoot.getInstance().getExtendedConfig().getIntProperty("org.pentaho.reporting.platform.plugin.cache.PentahoDataCache.CachableRowLimit");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Maximum Rows: " + this.maximumRows));
        }
        this.cacheManager = PentahoSystem.getCacheManager(null);
        this.manager = new PentahoDataCacheManager();
        if (this.cacheManager != null && !this.cacheManager.cacheEnabled(CACHE_NAME) && !this.cacheManager.addCacheRegion(CACHE_NAME)) {
            this.cacheManager = null;
            this.manager.cacheManager = null;
            throw new IllegalStateException("PentahoDataCache (report-dataset-cache) cannot be initialized");
        }
        PentahoSystem.addLogoutListener((ILogoutListener)this);
    }

    public synchronized TableModel get(DataCacheKey key) {
        if (this.cacheManager == null) {
            return null;
        }
        IPentahoSession session = PentahoSessionHolder.getSession();
        if (log.isDebugEnabled()) {
            log.debug((Object)("looking up key for session " + session.getId()));
        }
        return (TableModel)this.cacheManager.getFromRegionCache(CACHE_NAME, (Object)new CompositeKey(session.getId(), key));
    }

    public synchronized TableModel put(DataCacheKey key, TableModel model) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"put() called");
        }
        IPentahoSession session = PentahoSessionHolder.getSession();
        if (this.cacheManager != null) {
            if (model.getRowCount() > this.maximumRows) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("too many rows (" + model.getRowCount() + " > " + this.maximumRows + ") not caching."));
                }
                return model;
            }
            if (!CachableTableModel.isSafeToCache((TableModel)model)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"model is not safe to cache. not caching.");
                }
                return model;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("placing model in cache for session " + session.getId() + " (rows=" + model.getColumnCount() + ")"));
            }
            CachableTableModel cacheModel = new CachableTableModel(model);
            this.cacheManager.putInRegionCache(CACHE_NAME, (Object)new CompositeKey(session.getId(), key), (Object)cacheModel);
            return cacheModel;
        }
        return model;
    }

    public DataCacheManager getCacheManager() {
        return this.manager;
    }

    public void onLogout(IPentahoSession session) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("killing session cache for " + session.getId()));
        }
        this.manager.killSessionCache(session);
    }

    private static class PentahoDataCacheManager
    implements DataCacheManager {
        private ICacheManager cacheManager = PentahoSystem.getCacheManager(null);

        private PentahoDataCacheManager() {
        }

        public void clearAll() {
            if (this.cacheManager != null) {
                IPentahoSession session = PentahoSessionHolder.getSession();
                this.cacheManager.killSessionCache(session);
            }
        }

        public void shutdown() {
            if (this.cacheManager != null) {
                IPentahoSession session = PentahoSessionHolder.getSession();
                this.cacheManager.killSessionCache(session);
            }
        }

        public void killSessionCache(IPentahoSession session) {
            block5: {
                if (this.cacheManager != null) {
                    try {
                        Set cachedObjects = this.cacheManager.getAllKeysFromRegionCache(PentahoDataCache.CACHE_NAME);
                        if (cachedObjects != null) {
                            for (Object k : cachedObjects) {
                                if (!(k instanceof CompositeKey)) continue;
                                CompositeKey key = (CompositeKey)k;
                                if (!key.sessionId.equals(session.getId())) continue;
                                this.cacheManager.removeFromRegionCache(PentahoDataCache.CACHE_NAME, (Object)key);
                            }
                        }
                    }
                    catch (Throwable e) {
                        if (!log.isDebugEnabled()) break block5;
                        log.debug((Object)"", e);
                    }
                }
            }
        }
    }

    public static class CompositeKey {
        public String sessionId;
        public DataCacheKey dataCacheKey;

        public CompositeKey(String sessionId, DataCacheKey dataCacheKey) {
            this.sessionId = sessionId;
            this.dataCacheKey = dataCacheKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompositeKey that = (CompositeKey)o;
            if (!this.sessionId.equals(that.sessionId)) {
                return false;
            }
            return this.dataCacheKey.equals((Object)that.dataCacheKey);
        }

        public int hashCode() {
            int result = this.sessionId.hashCode();
            result = 31 * result + this.dataCacheKey.hashCode();
            return result;
        }
    }
}

