/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.connection;

import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.parser.data.sql.ConnectionReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.StringReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.pentaho.reporting.platform.plugin.connection.PentahoJndiDatasourceConnectionProvider;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PentahoJndiConnectionReadHandler
extends AbstractXmlReadHandler
implements ConnectionReadHandler {
    private ConnectionProvider connectionProvider;
    private StringReadHandler pathReadHandler;
    private StringReadHandler usernameReadHandler;
    private StringReadHandler passwordReadHandler;

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("path".equals(tagName)) {
            this.pathReadHandler = new StringReadHandler();
            return this.pathReadHandler;
        }
        if ("username".equals(tagName)) {
            this.usernameReadHandler = new StringReadHandler();
            return this.usernameReadHandler;
        }
        if ("password".equals(tagName)) {
            this.passwordReadHandler = new StringReadHandler();
            return this.passwordReadHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        PentahoJndiDatasourceConnectionProvider provider = new PentahoJndiDatasourceConnectionProvider();
        if (this.pathReadHandler != null) {
            provider.setJndiName(this.pathReadHandler.getResult());
        }
        if (this.usernameReadHandler != null) {
            provider.setUsername(this.usernameReadHandler.getResult());
        }
        if (this.passwordReadHandler != null) {
            provider.setPassword(this.passwordReadHandler.getResult());
        }
        this.connectionProvider = provider;
    }

    public ConnectionProvider getProvider() {
        return this.connectionProvider;
    }

    public Object getObject() throws SAXException {
        return this.connectionProvider;
    }
}

