/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.connection;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.pentaho.platform.api.data.IDBDatasourceService;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DataSourceProvider;
import org.pentaho.reporting.platform.plugin.connection.Messages;

public class PentahoMondrianDataSourceProvider
implements DataSourceProvider {
    private String dataSourceName;

    public PentahoMondrianDataSourceProvider(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public DataSource getDataSource() throws SQLException {
        try {
            IDBDatasourceService datasourceService = (IDBDatasourceService)PentahoSystem.getObjectFactory().get(IDBDatasourceService.class, null);
            DataSource dataSource = datasourceService.getDataSource(this.dataSourceName);
            if (dataSource != null) {
                return dataSource;
            }
            datasourceService.clearDataSource(this.dataSourceName);
            throw new SQLException(Messages.getInstance().getErrorString("PentahoDatasourceConnectionProvider.ERROR_0001_INVALID_CONNECTION", new Object[]{this.dataSourceName}));
        }
        catch (Exception e) {
            try {
                IDBDatasourceService datasourceService = (IDBDatasourceService)PentahoSystem.getObjectFactory().get(IDBDatasourceService.class, null);
                datasourceService.clearDataSource(this.dataSourceName);
                throw new SQLException(Messages.getInstance().getErrorString("PentahoDatasourceConnectionProvider.ERROR_0002_UNABLE_TO_FACTORY_OBJECT", new Object[]{this.dataSourceName, e.getLocalizedMessage()}));
            }
            catch (ObjectFactoryException objface) {
                throw new SQLException(Messages.getInstance().getErrorString("PentahoDatasourceConnectionProvider.ERROR_0002_UNABLE_TO_FACTORY_OBJECT", new Object[]{this.dataSourceName, e.getLocalizedMessage()}));
            }
        }
    }

    public Object getConnectionHash() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getClass().getName());
        list.add(this.dataSourceName);
        return list;
    }
}

