/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.output;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlContentItems;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.URLRewriter;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultNameGenerator;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.file.FileRepository;
import org.pentaho.reporting.libraries.repository.stream.StreamRepository;
import org.pentaho.reporting.platform.plugin.messages.Messages;
import org.pentaho.reporting.platform.plugin.output.ReportOutputHandler;
import org.pentaho.reporting.platform.plugin.repository.PentahoNameGenerator;
import org.pentaho.reporting.platform.plugin.repository.PentahoURLRewriter;

public abstract class AbstractHtmlOutput
implements ReportOutputHandler {
    private String contentHandlerPattern;

    protected AbstractHtmlOutput(String contentHandlerPattern) {
        this.contentHandlerPattern = contentHandlerPattern;
    }

    protected AbstractHtmlOutput() {
    }

    public void setContentHandlerPattern(String contentHandlerPattern) {
        this.contentHandlerPattern = contentHandlerPattern;
    }

    public String getContentHandlerPattern() {
        return this.contentHandlerPattern;
    }

    @Override
    public int generate(MasterReport report, int acceptedPage, OutputStream outputStream, int yieldRate) throws ReportProcessingException, IOException, ContentIOException {
        return 0;
    }

    @Override
    public int paginate(MasterReport report, int yieldRate) throws ReportProcessingException, IOException, ContentIOException {
        return 0;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean supportsPagination() {
        return false;
    }

    @Override
    public Object getReportLock() {
        return this;
    }

    protected boolean isSafeToDelete() {
        return "true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.platform.plugin.AlwaysDeleteHtmlDataFiles", "true"));
    }

    protected FastHtmlContentItems computeContentItems(OutputStream outputStream) throws ReportProcessingException, ContentIOException {
        PentahoURLRewriter rewriter;
        PentahoNameGenerator dataNameGenerator;
        ContentLocation dataLocation;
        IApplicationContext ctx = PentahoSystem.getApplicationContext();
        if (ctx != null) {
            File dataDirectory = new File(ctx.getFileOutputPath("system/tmp/"));
            if (dataDirectory.exists() && !dataDirectory.isDirectory()) {
                if (!(dataDirectory = dataDirectory.getParentFile()).isDirectory()) {
                    throw new ReportProcessingException("Dead " + dataDirectory.getPath());
                }
            } else if (!dataDirectory.exists()) {
                dataDirectory.mkdirs();
            }
            FileRepository dataRepository = new FileRepository(dataDirectory);
            dataLocation = dataRepository.getRoot();
            dataNameGenerator = this.createPentahoNameGenerator();
            dataNameGenerator.initialize(dataLocation, this.isSafeToDelete());
            rewriter = new PentahoURLRewriter(this.contentHandlerPattern, false);
        } else {
            dataLocation = null;
            dataNameGenerator = null;
            rewriter = new PentahoURLRewriter(this.contentHandlerPattern, false);
        }
        StreamRepository targetRepository = new StreamRepository(null, outputStream, "report");
        ContentLocation targetRoot = targetRepository.getRoot();
        FastHtmlContentItems retval = new FastHtmlContentItems();
        retval.setContentWriter(targetRoot, (NameGenerator)new DefaultNameGenerator(targetRoot, "index", "html"));
        retval.setDataWriter(dataLocation, (NameGenerator)dataNameGenerator);
        retval.setUrlRewriter((URLRewriter)rewriter);
        return retval;
    }

    protected PentahoNameGenerator createPentahoNameGenerator() {
        PentahoNameGenerator dataNameGenerator = (PentahoNameGenerator)PentahoSystem.get(PentahoNameGenerator.class);
        if (dataNameGenerator == null) {
            throw new IllegalStateException(Messages.getInstance().getString("ReportPlugin.errorNameGeneratorMissingConfiguration"));
        }
        return dataNameGenerator;
    }
}

