/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.output;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.ExtendedConfiguration;
import org.pentaho.reporting.platform.plugin.messages.Messages;
import org.pentaho.reporting.platform.plugin.output.CSVOutput;
import org.pentaho.reporting.platform.plugin.output.CachingPageableHTMLOutput;
import org.pentaho.reporting.platform.plugin.output.EmailOutput;
import org.pentaho.reporting.platform.plugin.output.PDFOutput;
import org.pentaho.reporting.platform.plugin.output.PNGOutput;
import org.pentaho.reporting.platform.plugin.output.PageableHTMLOutput;
import org.pentaho.reporting.platform.plugin.output.PlainTextOutput;
import org.pentaho.reporting.platform.plugin.output.RTFOutput;
import org.pentaho.reporting.platform.plugin.output.ReportOutputHandler;
import org.pentaho.reporting.platform.plugin.output.ReportOutputHandlerFactory;
import org.pentaho.reporting.platform.plugin.output.ReportOutputHandlerSelector;
import org.pentaho.reporting.platform.plugin.output.StreamHtmlOutput;
import org.pentaho.reporting.platform.plugin.output.StreamJcrHtmlOutput;
import org.pentaho.reporting.platform.plugin.output.XLSOutput;
import org.pentaho.reporting.platform.plugin.output.XLSXOutput;
import org.pentaho.reporting.platform.plugin.output.XmlPageableOutput;
import org.pentaho.reporting.platform.plugin.output.XmlTableOutput;

public class DefaultReportOutputHandlerFactory
implements ReportOutputHandlerFactory {
    private boolean htmlStreamVisible = true;
    private boolean htmlPageVisible = true;
    private boolean xlsVisible = true;
    private boolean xlsxVisible = true;
    private boolean csvVisible = true;
    private boolean rtfVisible = true;
    private boolean pdfVisible = true;
    private boolean textVisible = true;
    private boolean mailVisible = true;
    private boolean xmlTableVisible = true;
    private boolean xmlPageVisible = true;
    private boolean pngVisible = true;
    private boolean htmlStreamAvailable = true;
    private boolean htmlPageAvailable = true;
    private boolean xlsAvailable = true;
    private boolean xlsxAvailable = true;
    private boolean csvAvailable = true;
    private boolean rtfAvailable = true;
    private boolean pdfAvailable = true;
    private boolean textAvailable = true;
    private boolean mailAvailable = true;
    private boolean xmlTableAvailable = true;
    private boolean xmlPageAvailable = true;
    private boolean pngAvailable = true;

    public boolean isHtmlStreamVisible() {
        return this.htmlStreamVisible;
    }

    public void setHtmlStreamVisible(boolean htmlStreamVisible) {
        this.htmlStreamVisible = htmlStreamVisible;
    }

    public boolean isHtmlPageVisible() {
        return this.htmlPageVisible;
    }

    public void setHtmlPageVisible(boolean htmlPageVisible) {
        this.htmlPageVisible = htmlPageVisible;
    }

    public boolean isXlsVisible() {
        return this.xlsVisible;
    }

    public void setXlsVisible(boolean xlsVisible) {
        this.xlsVisible = xlsVisible;
    }

    public boolean isXlsxVisible() {
        return this.xlsxVisible;
    }

    public void setXlsxVisible(boolean xlsxVisible) {
        this.xlsxVisible = xlsxVisible;
    }

    public boolean isCsvVisible() {
        return this.csvVisible;
    }

    public void setCsvVisible(boolean csvVisible) {
        this.csvVisible = csvVisible;
    }

    public boolean isRtfVisible() {
        return this.rtfVisible;
    }

    public void setRtfVisible(boolean rtfVisible) {
        this.rtfVisible = rtfVisible;
    }

    public boolean isPdfVisible() {
        return this.pdfVisible;
    }

    public void setPdfVisible(boolean pdfVisible) {
        this.pdfVisible = pdfVisible;
    }

    public boolean isTextVisible() {
        return this.textVisible;
    }

    public void setTextVisible(boolean textVisible) {
        this.textVisible = textVisible;
    }

    public boolean isMailVisible() {
        return this.mailVisible;
    }

    public void setMailVisible(boolean mailVisible) {
        this.mailVisible = mailVisible;
    }

    public boolean isXmlTableVisible() {
        return this.xmlTableVisible;
    }

    public void setXmlTableVisible(boolean xmlTableVisible) {
        this.xmlTableVisible = xmlTableVisible;
    }

    public boolean isXmlPageVisible() {
        return this.xmlPageVisible;
    }

    public void setXmlPageVisible(boolean xmlPageVisible) {
        this.xmlPageVisible = xmlPageVisible;
    }

    public boolean isPngVisible() {
        return this.pngVisible;
    }

    public void setPngVisible(boolean pngVisible) {
        this.pngVisible = pngVisible;
    }

    public boolean isHtmlStreamAvailable() {
        return this.htmlStreamAvailable;
    }

    public void setHtmlStreamAvailable(boolean htmlStreamAvailable) {
        this.htmlStreamAvailable = htmlStreamAvailable;
    }

    public boolean isHtmlPageAvailable() {
        return this.htmlPageAvailable;
    }

    public void setHtmlPageAvailable(boolean htmlPageAvailable) {
        this.htmlPageAvailable = htmlPageAvailable;
    }

    public boolean isXlsAvailable() {
        return this.xlsAvailable;
    }

    public void setXlsAvailable(boolean xlsAvailable) {
        this.xlsAvailable = xlsAvailable;
    }

    public boolean isXlsxAvailable() {
        return this.xlsxAvailable;
    }

    public void setXlsxAvailable(boolean xlsxAvailable) {
        this.xlsxAvailable = xlsxAvailable;
    }

    public boolean isCsvAvailable() {
        return this.csvAvailable;
    }

    public void setCsvAvailable(boolean csvAvailable) {
        this.csvAvailable = csvAvailable;
    }

    public boolean isRtfAvailable() {
        return this.rtfAvailable;
    }

    public void setRtfAvailable(boolean rtfAvailable) {
        this.rtfAvailable = rtfAvailable;
    }

    public boolean isPdfAvailable() {
        return this.pdfAvailable;
    }

    public void setPdfAvailable(boolean pdfAvailable) {
        this.pdfAvailable = pdfAvailable;
    }

    public boolean isTextAvailable() {
        return this.textAvailable;
    }

    public void setTextAvailable(boolean textAvailable) {
        this.textAvailable = textAvailable;
    }

    public boolean isMailAvailable() {
        return this.mailAvailable;
    }

    public void setMailAvailable(boolean mailAvailable) {
        this.mailAvailable = mailAvailable;
    }

    public boolean isXmlTableAvailable() {
        return this.xmlTableAvailable;
    }

    public void setXmlTableAvailable(boolean xmlTableAvailable) {
        this.xmlTableAvailable = xmlTableAvailable;
    }

    public boolean isXmlPageAvailable() {
        return this.xmlPageAvailable;
    }

    public void setXmlPageAvailable(boolean xmlPageAvailable) {
        this.xmlPageAvailable = xmlPageAvailable;
    }

    public boolean isPngAvailable() {
        return this.pngAvailable;
    }

    public void setPngAvailable(boolean pngAvailable) {
        this.pngAvailable = pngAvailable;
    }

    @Override
    public String getMimeType(ReportOutputHandlerSelector selector) {
        String outputTarget = selector.getOutputType();
        if (this.isHtmlPageAvailable() && "table/html;page-mode=stream".equals(outputTarget)) {
            return "text/html";
        }
        if (this.isHtmlPageAvailable() && "table/html;page-mode=page".equals(outputTarget)) {
            return "text/html";
        }
        if (this.isXlsAvailable() && "table/excel;page-mode=flow".equals(outputTarget)) {
            return "application/vnd.ms-excel";
        }
        if (this.isXlsxAvailable() && "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;page-mode=flow".equals(outputTarget)) {
            return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        }
        if (this.isCsvAvailable() && "table/csv;page-mode=stream".equals(outputTarget)) {
            return "text/csv";
        }
        if (this.isRtfAvailable() && "table/rtf;page-mode=flow".equals(outputTarget)) {
            return "application/rtf";
        }
        if (this.isPdfAvailable() && "pageable/pdf".equals(outputTarget)) {
            return "application/pdf";
        }
        if (this.isTextAvailable() && "pageable/text".equals(outputTarget)) {
            return "text/plain";
        }
        if (this.isMailAvailable() && "mime-message/text/html".equals(outputTarget)) {
            return "mime-message/text/html";
        }
        if (this.isXmlTableAvailable() && "table/xml".equals(outputTarget)) {
            return "application/xml";
        }
        if (this.isXmlPageAvailable() && "pageable/xml".equals(outputTarget)) {
            return "application/xml";
        }
        if (this.isPngAvailable() && "pageable/X-AWT-Graphics;image-type=png".equals(outputTarget)) {
            return "image/png";
        }
        return "application/octet-stream";
    }

    @Override
    public Set<Map.Entry<String, String>> getSupportedOutputTypes() {
        Messages m = Messages.getInstance();
        LinkedHashMap<String, String> outputTypes = new LinkedHashMap<String, String>();
        if (this.isHtmlPageVisible() && this.isHtmlPageAvailable()) {
            outputTypes.put("table/html;page-mode=page", m.getString("ReportPlugin.outputHTMLPaginated"));
        }
        if (this.isHtmlStreamVisible() && this.isHtmlStreamAvailable()) {
            outputTypes.put("table/html;page-mode=stream", m.getString("ReportPlugin.outputHTMLStream"));
        }
        if (this.isMailVisible() && this.isMailAvailable()) {
            outputTypes.put("mime-message/text/html", m.getString("ReportPlugin.outputEmail"));
        }
        if (this.isPdfVisible() && this.isPdfAvailable()) {
            outputTypes.put("pageable/pdf", m.getString("ReportPlugin.outputPDF"));
        }
        if (this.isXlsVisible() && this.isXlsAvailable()) {
            outputTypes.put("table/excel;page-mode=flow", m.getString("ReportPlugin.outputXLS"));
        }
        if (this.isXlsxVisible() && this.isXlsxAvailable()) {
            outputTypes.put("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;page-mode=flow", m.getString("ReportPlugin.outputXLSX"));
        }
        if (this.isCsvVisible() && this.isCsvAvailable()) {
            outputTypes.put("table/csv;page-mode=stream", m.getString("ReportPlugin.outputCSV"));
        }
        if (this.isRtfVisible() && this.isRtfAvailable()) {
            outputTypes.put("table/rtf;page-mode=flow", m.getString("ReportPlugin.outputRTF"));
        }
        if (this.isTextVisible() && this.isTextAvailable()) {
            outputTypes.put("pageable/text", m.getString("ReportPlugin.outputTXT"));
        }
        return Collections.unmodifiableSet(outputTypes.entrySet());
    }

    @Override
    public ReportOutputHandler createOutputHandlerForOutputType(ReportOutputHandlerSelector selector) throws IOException {
        String t = selector.getOutputType();
        if ("table/html;page-mode=page".equals(t)) {
            return this.createHtmlPageOutput(selector);
        }
        if ("table/html;page-mode=stream".equals(t)) {
            return this.createHtmlStreamOutput(selector);
        }
        if ("pageable/X-AWT-Graphics;image-type=png".equals(t)) {
            return this.createPngOutput();
        }
        if ("pageable/xml".equals(t)) {
            return this.createXmlPageableOutput();
        }
        if ("table/xml".equals(t)) {
            return this.createXmlTableOutput();
        }
        if ("pageable/pdf".equals(t)) {
            return this.createPdfOutput();
        }
        if ("table/excel;page-mode=flow".equals(t)) {
            return this.createXlsOutput(selector);
        }
        if ("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;page-mode=flow".equals(t)) {
            return this.createXlsxOutput(selector);
        }
        if ("table/csv;page-mode=stream".equals(t)) {
            return this.createCsvOutput();
        }
        if ("table/rtf;page-mode=flow".equals(t)) {
            return this.createRtfOutput();
        }
        if ("mime-message/text/html".equals(t)) {
            return this.createMailOutput();
        }
        if ("pageable/text".equals(t)) {
            return this.createTextOutput();
        }
        return null;
    }

    protected ReportOutputHandler createTextOutput() {
        if (!this.isTextAvailable()) {
            return null;
        }
        return new PlainTextOutput();
    }

    protected ReportOutputHandler createMailOutput() {
        if (!this.isMailAvailable()) {
            return null;
        }
        return new EmailOutput();
    }

    protected ReportOutputHandler createRtfOutput() {
        if (!this.isRtfAvailable()) {
            return null;
        }
        return new RTFOutput();
    }

    protected ReportOutputHandler createCsvOutput() {
        if (!this.isCsvAvailable()) {
            return null;
        }
        return new CSVOutput();
    }

    protected ReportOutputHandler createXlsxOutput(ReportOutputHandlerSelector selector) throws IOException {
        if (!this.isXlsxAvailable()) {
            return null;
        }
        XLSXOutput xlsxOutput = new XLSXOutput();
        xlsxOutput.setTemplateDataFromStream(selector.getInput("workbook", null, InputStream.class));
        return xlsxOutput;
    }

    protected ReportOutputHandler createXlsOutput(ReportOutputHandlerSelector selector) throws IOException {
        if (!this.isXlsAvailable()) {
            return null;
        }
        XLSOutput xlsOutput = new XLSOutput();
        xlsOutput.setTemplateDataFromStream(selector.getInput("workbook", null, InputStream.class));
        return xlsOutput;
    }

    protected ReportOutputHandler createPdfOutput() {
        if (!this.isPdfAvailable()) {
            return null;
        }
        return new PDFOutput();
    }

    protected ReportOutputHandler createXmlTableOutput() {
        if (!this.isXmlTableAvailable()) {
            return null;
        }
        return new XmlTableOutput();
    }

    protected ReportOutputHandler createXmlPageableOutput() {
        if (!this.isXmlPageAvailable()) {
            return null;
        }
        return new XmlPageableOutput();
    }

    protected ReportOutputHandler createPngOutput() {
        if (!this.isPngAvailable()) {
            return null;
        }
        return new PNGOutput();
    }

    protected ReportOutputHandler createHtmlStreamOutput(ReportOutputHandlerSelector selector) {
        if (!this.isHtmlStreamAvailable()) {
            return null;
        }
        if (selector.isUseJcrOutput()) {
            String contentHandlerPattern = this.computeContentHandlerPattern(selector);
            StreamJcrHtmlOutput streamJcrHtmlOutput = new StreamJcrHtmlOutput();
            streamJcrHtmlOutput.setContentHandlerPattern(contentHandlerPattern);
            streamJcrHtmlOutput.setJcrOutputPath(selector.getJcrOutputPath());
            return streamJcrHtmlOutput;
        }
        String contentHandlerPattern = this.computeContentHandlerPattern(selector);
        StreamHtmlOutput streamHtmlOutput = new StreamHtmlOutput();
        streamHtmlOutput.setContentHandlerPattern(contentHandlerPattern);
        return streamHtmlOutput;
    }

    protected String computeContentHandlerPattern(ReportOutputHandlerSelector selector) {
        String configKey = selector.isUseJcrOutput() ? "org.pentaho.web.JcrContentHandler" : "org.pentaho.web.ContentHandler";
        Configuration globalConfig = ClassicEngineBoot.getInstance().getGlobalConfig();
        String contentHandlerPattern = PentahoRequestContextHolder.getRequestContext().getContextPath();
        contentHandlerPattern = contentHandlerPattern + selector.getInput("content-handler-pattern", globalConfig.getConfigProperty(configKey), String.class);
        return contentHandlerPattern;
    }

    protected ReportOutputHandler createHtmlPageOutput(ReportOutputHandlerSelector selector) {
        if (!this.isHtmlPageAvailable()) {
            return null;
        }
        String contentHandlerPattern = this.computeContentHandlerPattern(selector);
        if (this.isCachePageableHtmlContentEnabled(selector.getReport())) {
            CachingPageableHTMLOutput pageableHTMLOutput = new CachingPageableHTMLOutput();
            pageableHTMLOutput.setContentHandlerPattern(contentHandlerPattern);
            pageableHTMLOutput.setJcrOutputPath(selector.isUseJcrOutput() ? selector.getJcrOutputPath() : null);
            return pageableHTMLOutput;
        }
        PageableHTMLOutput pageableHTMLOutput = new PageableHTMLOutput();
        pageableHTMLOutput.setContentHandlerPattern(contentHandlerPattern);
        return pageableHTMLOutput;
    }

    protected boolean isCachePageableHtmlContentEnabled(MasterReport report) {
        Object isAtReportLevelCacheEnabled = report.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/pentaho", "dynamic-report-cache");
        if (isAtReportLevelCacheEnabled != null) {
            return Boolean.TRUE.equals(isAtReportLevelCacheEnabled);
        }
        ExtendedConfiguration config = ClassicEngineBoot.getInstance().getExtendedConfig();
        return config.getBoolProperty("org.pentaho.reporting.platform.plugin.output.CachePageableHtmlContent");
    }
}

