/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.output;

import java.io.IOException;
import java.io.InputStream;
import org.pentaho.reporting.platform.plugin.output.DefaultReportOutputHandlerFactory;
import org.pentaho.reporting.platform.plugin.output.FastCSVOutput;
import org.pentaho.reporting.platform.plugin.output.FastStreamHtmlOutput;
import org.pentaho.reporting.platform.plugin.output.FastStreamJcrHtmlOutput;
import org.pentaho.reporting.platform.plugin.output.FastXLSOutput;
import org.pentaho.reporting.platform.plugin.output.FastXLSXOutput;
import org.pentaho.reporting.platform.plugin.output.ReportOutputHandler;
import org.pentaho.reporting.platform.plugin.output.ReportOutputHandlerSelector;
import org.pentaho.reporting.platform.plugin.output.XLSOutput;
import org.pentaho.reporting.platform.plugin.output.XLSXOutput;

public class FastExportReportOutputHandlerFactory
extends DefaultReportOutputHandlerFactory {
    @Override
    protected ReportOutputHandler createXlsxOutput(ReportOutputHandlerSelector selector) throws IOException {
        if (!this.isXlsxAvailable()) {
            return null;
        }
        InputStream input = selector.getInput("workbook", null, InputStream.class);
        if (input != null) {
            XLSXOutput xlsxOutput = new XLSXOutput();
            xlsxOutput.setTemplateDataFromStream(input);
            return xlsxOutput;
        }
        return new FastXLSXOutput();
    }

    @Override
    protected ReportOutputHandler createXlsOutput(ReportOutputHandlerSelector selector) throws IOException {
        if (!this.isXlsxAvailable()) {
            return null;
        }
        InputStream input = selector.getInput("workbook", null, InputStream.class);
        if (input != null) {
            XLSOutput xlsOutput = new XLSOutput();
            xlsOutput.setTemplateDataFromStream(input);
            return xlsOutput;
        }
        return new FastXLSOutput();
    }

    @Override
    protected ReportOutputHandler createCsvOutput() {
        if (!this.isCsvAvailable()) {
            return null;
        }
        return new FastCSVOutput();
    }

    @Override
    protected ReportOutputHandler createHtmlStreamOutput(ReportOutputHandlerSelector selector) {
        if (!this.isHtmlStreamAvailable()) {
            return null;
        }
        if (selector.isUseJcrOutput()) {
            return new FastStreamJcrHtmlOutput(this.computeContentHandlerPattern(selector), selector.getJcrOutputPath());
        }
        return new FastStreamHtmlOutput(this.computeContentHandlerPattern(selector));
    }
}

