/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.output;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.PageDrawable;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.PrintReportProcessor;
import org.pentaho.reporting.libraries.base.util.PngEncoder;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.platform.plugin.output.ReportOutputHandler;

public class PNGOutput
implements ReportOutputHandler {
    private transient PrintReportProcessor proc;

    @Override
    public Object getReportLock() {
        return this;
    }

    @Override
    public boolean supportsPagination() {
        return false;
    }

    @Override
    public void close() {
        if (this.proc != null) {
            this.proc.close();
        }
    }

    @Override
    public int paginate(MasterReport report, int yieldRate) throws ReportProcessingException, IOException, ContentIOException {
        return 0;
    }

    @Override
    public int generate(MasterReport report, int acceptedPage, OutputStream outputStream, int yieldRate) throws ReportProcessingException, IOException, ContentIOException {
        int pageCount;
        if (this.proc == null) {
            this.proc = this.create(report, yieldRate);
        }
        if (!this.proc.isPaginated()) {
            this.proc.paginate();
        }
        if ((pageCount = this.proc.getNumberOfPages()) <= acceptedPage) {
            return -1;
        }
        BufferedImage image = PNGOutput.createImage(this.proc.getPageFormat(acceptedPage));
        Rectangle rect = new Rectangle(0, 0, image.getWidth(), image.getHeight());
        Graphics2D g2 = image.createGraphics();
        g2.setPaint(Color.white);
        g2.fill(rect);
        PageDrawable pageDrawable = this.proc.getPageDrawable(acceptedPage);
        pageDrawable.draw(g2, (Rectangle2D)rect);
        g2.dispose();
        PngEncoder encoder = new PngEncoder((Image)image, true, 0, 9);
        byte[] data = encoder.pngEncode();
        outputStream.write(data);
        outputStream.flush();
        outputStream.close();
        return 0;
    }

    private PrintReportProcessor create(MasterReport report, int yieldRate) throws ReportProcessingException {
        PrintReportProcessor proc = new PrintReportProcessor(report);
        if (yieldRate > 0) {
            proc.addReportProgressListener((ReportProgressListener)this.getYieldListener(yieldRate));
        }
        return proc;
    }

    private static BufferedImage createImage(PageFormat pf) {
        double width = pf.getWidth();
        double height = pf.getHeight();
        return new BufferedImage((int)width, (int)height, 13);
    }
}

