/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.output;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.reporting.platform.plugin.cache.IReportContent;

class PaginationControlWrapper {
    private static Log logger = LogFactory.getLog(PaginationControlWrapper.class);
    private static final String TEMPLATE_PATH = "system/reporting/reportviewer/paginationTemplate.html";
    private static final String STAGING_PATH = "system/tmp/";
    private static final Pattern CSS = Pattern.compile("(.*link.*\\/getImage\\?image=)(.*)(\".*)");
    private static final Pattern IMG = Pattern.compile("(.*img.*src=\")(http.+)(\\/getImage\\?image=)(.*)(\".*)");
    private static String pageableHtml;

    private PaginationControlWrapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(OutputStream stream, IReportContent content) throws IOException {
        StringBuilder builder = new StringBuilder();
        String string = TEMPLATE_PATH;
        synchronized (TEMPLATE_PATH) {
            if (StringUtil.isEmpty((String)pageableHtml)) {
                pageableHtml = PaginationControlWrapper.getSolutionDirFileContent(TEMPLATE_PATH);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            String pages = PaginationControlWrapper.getPageArray(content, builder);
            StrSubstitutor substitutor = new StrSubstitutor(Collections.singletonMap("pages", pages));
            String filledTemplate = substitutor.replace(pageableHtml);
            stream.write(filledTemplate.getBytes());
            stream.flush();
            return;
        }
    }

    private static String getPageArray(IReportContent content, StringBuilder builder) throws IOException {
        builder.append("var pages = [ ");
        int index = 0;
        byte[] page = content.getPageData(index);
        while (page != null) {
            String pageContent = new String(page, "UTF-8");
            try {
                pageContent = PaginationControlWrapper.embedCss(pageContent);
                pageContent = PaginationControlWrapper.replaceImgSrc(pageContent);
            }
            catch (IOException e) {
                logger.error((Object)"Can't embed styles and images into scheduled HTML file: ", (Throwable)e);
            }
            builder.append('\'').append(Base64.encodeBase64String((byte[])StringEscapeUtils.escapeHtml((String)pageContent).getBytes("UTF-8"))).append('\'').append(", \n");
            page = content.getPageData(++index);
        }
        builder.setLength(builder.length() - 3);
        builder.append(" ];\n");
        return builder.toString();
    }

    private static String embedCss(String pageContent) throws IOException {
        Matcher cssLinkMatcher = CSS.matcher(pageContent);
        while (cssLinkMatcher.find() && cssLinkMatcher.groupCount() > 1) {
            String cssContent = PaginationControlWrapper.getSolutionDirFileContent(STAGING_PATH + cssLinkMatcher.group(2));
            pageContent = cssLinkMatcher.replaceFirst("<style>\n" + cssContent + "\n</style>");
            cssLinkMatcher = CSS.matcher(pageContent);
        }
        return pageContent;
    }

    private static String replaceImgSrc(String pageContent) throws IOException {
        String fullyQualifiedServerUrl = PentahoSystem.getApplicationContext().getFullyQualifiedServerURL();
        URL url = new URL(fullyQualifiedServerUrl);
        String garbage = url.getProtocol() + "://" + url.getHost() + ":" + url.getPort();
        String prefix = fullyQualifiedServerUrl.substring(garbage.length(), fullyQualifiedServerUrl.length() - 1);
        Matcher imgLinkMatcher = IMG.matcher(pageContent);
        while (imgLinkMatcher.find() && imgLinkMatcher.groupCount() > 1) {
            String imgContent = imgLinkMatcher.group(0);
            imgContent = imgContent.replace(imgLinkMatcher.group(2), prefix);
            pageContent = imgLinkMatcher.replaceFirst(imgContent);
            imgLinkMatcher = IMG.matcher(pageContent);
        }
        return pageContent;
    }

    private static String getSolutionDirFileContent(String path) throws IOException {
        String templateFile;
        IApplicationContext context = PentahoSystem.getApplicationContext();
        String string = templateFile = context == null ? null : context.getSolutionPath(path);
        if (!StringUtil.isEmpty((String)templateFile)) {
            try (FileInputStream fis = new FileInputStream(templateFile);){
                String string2 = IOUtils.toString((InputStream)fis);
                return string2;
            }
        }
        throw new FileNotFoundException("Can't find file in solution directory: system/reporting/reportviewer/paginationTemplate.html");
    }
}

