/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.output;

import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.AllPageFlowSelector;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageFlowSelector;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.SinglePageFlowSelector;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.xml.XmlPageOutputProcessor;
import org.pentaho.reporting.platform.plugin.async.IAsyncReportListener;
import org.pentaho.reporting.platform.plugin.async.ReportListenerThreadHolder;
import org.pentaho.reporting.platform.plugin.output.ProxyOutputStream;
import org.pentaho.reporting.platform.plugin.output.ReportOutputHandler;

public class XmlPageableOutput
implements ReportOutputHandler {
    private PageableReportProcessor proc;
    private ProxyOutputStream proxyOutputStream;

    @Override
    public Object getReportLock() {
        return this;
    }

    private PageableReportProcessor createProcessor(MasterReport report, int yieldRate) throws ReportProcessingException {
        this.proxyOutputStream = new ProxyOutputStream();
        XmlPageOutputProcessor outputProcessor = new XmlPageOutputProcessor(report.getConfiguration(), (OutputStream)this.proxyOutputStream);
        PageableReportProcessor proc = new PageableReportProcessor(report, (PageableOutputProcessor)outputProcessor);
        if (yieldRate > 0) {
            proc.addReportProgressListener((ReportProgressListener)this.getYieldListener(yieldRate));
        }
        return proc;
    }

    @Override
    public int paginate(MasterReport report, int yieldRate) throws ReportProcessingException, IOException {
        if (this.proc == null) {
            this.proc = this.createProcessor(report, yieldRate);
        }
        this.proc.paginate();
        return this.proc.getPhysicalPageCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int generate(MasterReport report, int acceptedPage, OutputStream outputStream, int yieldRate) throws ReportProcessingException, IOException {
        IAsyncReportListener listener;
        if (this.proc == null) {
            this.proc = this.createProcessor(report, yieldRate);
        }
        if ((listener = ReportListenerThreadHolder.getListener()) != null) {
            this.proc.addReportProgressListener((ReportProgressListener)listener);
        }
        try {
            if (acceptedPage >= 0) {
                XmlPageOutputProcessor outputProcessor = (XmlPageOutputProcessor)this.proc.getOutputProcessor();
                outputProcessor.setFlowSelector((PageFlowSelector)new SinglePageFlowSelector(acceptedPage, false));
            }
            this.proxyOutputStream.setParent(outputStream);
            this.proc.processReport();
            if (listener != null) {
                listener.setIsQueryLimitReached(this.proc.isQueryLimitReached());
            }
            int n = this.proc.getPhysicalPageCount();
            return n;
        }
        finally {
            if (listener != null) {
                this.proc.removeReportProgressListener((ReportProgressListener)listener);
            }
            if (acceptedPage >= 0) {
                XmlPageOutputProcessor outputProcessor = (XmlPageOutputProcessor)this.proc.getOutputProcessor();
                outputProcessor.setFlowSelector((PageFlowSelector)new AllPageFlowSelector());
            }
            if (this.proxyOutputStream != null) {
                this.proxyOutputStream.setParent(null);
            }
        }
    }

    @Override
    public boolean supportsPagination() {
        return true;
    }

    @Override
    public void close() {
        if (this.proc != null) {
            this.proc.close();
            this.proc = null;
            this.proxyOutputStream = null;
        }
    }
}

