/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.repository;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.unified.fileio.RepositoryFileOutputStream;
import org.pentaho.platform.util.web.MimeHelper;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.repository.ContentCreationException;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.platform.plugin.repository.ReportContentItem;
import org.pentaho.reporting.platform.plugin.repository.ReportContentRepository;

public class ReportContentLocation
implements ContentLocation {
    private RepositoryFile location;
    private ReportContentRepository repository;
    private String[] hiddenExtensions = new String[]{".jpe", ".jpeg", ".jpg", ".png", ".css"};
    public static final String RESERVEDMAPKEY_LINEAGE_ID = "lineage-id";

    public ReportContentLocation(RepositoryFile location, ReportContentRepository repository) {
        if (location == null) {
            throw new NullPointerException("Content-Location cannot be null");
        }
        if (repository == null) {
            throw new NullPointerException();
        }
        this.location = location;
        this.repository = repository;
    }

    public ContentEntity[] listContents() throws ContentIOException {
        ArrayList<ReportContentItem> itemCollection = new ArrayList<ReportContentItem>();
        IUnifiedRepository repo = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
        for (RepositoryFile child : repo.getChildren(this.location.getId())) {
            itemCollection.add(new ReportContentItem(child, this, MimeHelper.getMimeTypeFromFileName((String)child.getName())));
        }
        return itemCollection.toArray(new ContentEntity[itemCollection.size()]);
    }

    public ContentEntity getEntry(String name) throws ContentIOException {
        String path;
        IUnifiedRepository repo = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
        RepositoryFile rawFile = repo.getFile(path = this.location.getPath() + "/" + name);
        if (rawFile == null) {
            throw new ContentIOException("Could not get ContentItem entry");
        }
        return new ReportContentItem(rawFile, this, MimeHelper.getMimeTypeFromFileName((String)name));
    }

    public ContentItem createItem(String name) throws ContentCreationException {
        IUnifiedRepository repo = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
        String extension = IOUtils.getInstance().getFileExtension(name);
        String mimeType = MimeHelper.getMimeTypeFromExtension((String)extension);
        RepositoryFileOutputStream rfos = null;
        String path = this.location.getPath() + "/" + name;
        if (repo.getFile(path) == null) {
            rfos = this.isHiddenExtension(extension) ? new RepositoryFileOutputStream(path, true) : new RepositoryFileOutputStream(path, false);
            try {
                rfos.close();
            }
            catch (IOException e) {
                throw new ContentCreationException(e.getMessage(), (Exception)e);
            }
        }
        Map meta = repo.getFileMetadata(repo.getFile(path).getId());
        meta.put(RESERVEDMAPKEY_LINEAGE_ID, UUID.randomUUID().toString());
        repo.setFileMetadata(repo.getFile(path).getId(), meta);
        return new ReportContentItem(repo.getFile(path), this, mimeType);
    }

    public ContentLocation createLocation(String string) throws ContentCreationException {
        throw new ContentCreationException("Cannot create a content-location: " + string);
    }

    public boolean exists(String name) {
        String path;
        IUnifiedRepository repo = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
        return repo.getFile(path = this.location.getPath() + "/" + name) != null;
    }

    public String getName() {
        return this.location.getName();
    }

    public Object getContentId() {
        return this.location.getId();
    }

    public Object getAttribute(String domain, String key) {
        if ("org.jfree.repository".equals(domain) && "version".equals(key)) {
            return this.location.getVersionId();
        }
        return null;
    }

    public boolean setAttribute(String domain, String key, Object object) {
        return false;
    }

    public ContentLocation getParent() {
        return null;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public boolean delete() {
        return false;
    }

    public boolean isHiddenExtension(String extension) {
        for (String ext : this.hiddenExtensions) {
            if (!ext.equals(extension)) continue;
            return true;
        }
        return false;
    }
}

