/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.staging;

import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.reporting.engine.classic.core.util.StagingMode;
import org.pentaho.reporting.platform.plugin.staging.MemStagingHandler;
import org.pentaho.reporting.platform.plugin.staging.StagingHandler;
import org.pentaho.reporting.platform.plugin.staging.TempFileStagingHandler;
import org.pentaho.reporting.platform.plugin.staging.ThruStagingHandler;

public abstract class AbstractStagingHandler
implements StagingHandler {
    protected OutputStream outputStream;
    protected IPentahoSession userSession;

    public AbstractStagingHandler(OutputStream outputStream, IPentahoSession userSession) throws IOException {
        this.outputStream = outputStream;
        this.userSession = userSession;
        this.initialize();
    }

    public static StagingHandler getStagingHandlerImpl(OutputStream outputStream, IPentahoSession userSession, StagingMode mode) throws IOException {
        if (mode.equals((Object)StagingMode.THRU)) {
            return new ThruStagingHandler(outputStream, userSession);
        }
        if (mode.equals((Object)StagingMode.TMPFILE)) {
            return new TempFileStagingHandler(outputStream, userSession);
        }
        if (mode.equals((Object)StagingMode.MEMORY)) {
            return new MemStagingHandler(outputStream, userSession);
        }
        return new ThruStagingHandler(outputStream, userSession);
    }

    protected abstract void initialize() throws IOException;
}

