/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.platform.plugin.staging;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.util.ITempFileDeleter;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.UUIDUtil;
import org.pentaho.reporting.engine.classic.core.util.StagingMode;
import org.pentaho.reporting.platform.plugin.TrackingOutputStream;
import org.pentaho.reporting.platform.plugin.staging.AbstractStagingHandler;

public class TempFileStagingHandler
extends AbstractStagingHandler {
    private static final Log logger = LogFactory.getLog(TempFileStagingHandler.class);
    private static String PREFIX = "repstg";
    private static String POSTFIX = ".tmp";
    private TrackingOutputStream fileTrackingStream;
    File tmpFile;

    public TempFileStagingHandler(OutputStream outputStream, IPentahoSession userSession) throws IOException {
        super(outputStream, userSession);
    }

    @Override
    protected void initialize() throws IOException {
        logger.trace((Object)"Staging mode set - TEMP_FILE");
        IApplicationContext appCtx = PentahoSystem.getApplicationContext();
        if (this.userSession.getId().length() >= 10) {
            this.tmpFile = appCtx.createTempFile(this.userSession, PREFIX, POSTFIX, true);
        } else {
            File parentDir = new File(appCtx.getSolutionPath("system/tmp"));
            ITempFileDeleter fileDeleter = (ITempFileDeleter)this.userSession.getAttribute("PENTAHO_TMP_DELETER");
            String newPrefix = PREFIX + UUIDUtil.getUUIDAsString().substring(0, 10) + "-";
            this.tmpFile = File.createTempFile(newPrefix, POSTFIX, parentDir);
            if (fileDeleter != null) {
                fileDeleter.trackTempFile(this.tmpFile);
            } else {
                this.tmpFile.deleteOnExit();
            }
        }
        this.fileTrackingStream = new TrackingOutputStream(new BufferedOutputStream(new FileOutputStream(this.tmpFile)));
    }

    @Override
    public void complete() throws IOException {
        IOUtils.closeQuietly((OutputStream)this.fileTrackingStream);
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.tmpFile));
        try {
            IOUtils.copy((InputStream)bis, (OutputStream)this.outputStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)bis);
        }
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((OutputStream)this.fileTrackingStream);
        if (this.tmpFile != null && this.tmpFile.exists()) {
            try {
                boolean deleted = this.tmpFile.delete();
                if (!deleted) {
                    logger.debug((Object)("Unable to delete temp file for user: " + this.userSession.getName()));
                }
            }
            catch (Exception ignored) {
                logger.debug((Object)("Exception when try to delete temp file for user: " + this.userSession.getName()));
            }
        }
    }

    @Override
    public int getWrittenByteCount() {
        return this.fileTrackingStream.getTrackingSize();
    }

    @Override
    public boolean canSendHeaders() {
        return true;
    }

    @Override
    public OutputStream getStagingOutputStream() {
        return this.fileTrackingStream;
    }

    @Override
    public boolean isFullyBuffered() {
        return true;
    }

    @Override
    public StagingMode getStagingMode() {
        return StagingMode.TMPFILE;
    }
}

