/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.itext;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.FontMapper;
import java.awt.Font;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.ExtendedConfiguration;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.fonts.FontMappingUtility;
import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.fonts.itext.BaseFontCreateException;
import org.pentaho.reporting.libraries.fonts.itext.BaseFontRecord;
import org.pentaho.reporting.libraries.fonts.itext.BaseFontRecordKey;
import org.pentaho.reporting.libraries.fonts.itext.ITextBuiltInFontRecord;
import org.pentaho.reporting.libraries.fonts.itext.ITextFontRegistry;
import org.pentaho.reporting.libraries.fonts.merge.CompoundFontRecord;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontRecord;
import org.pentaho.reporting.libraries.fonts.registry.FontSource;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFontRecord;

public class BaseFontSupport
implements FontMapper {
    private static final Log logger = LogFactory.getLog(BaseFontSupport.class);
    private final Map baseFonts = new HashMap();
    private String defaultEncoding;
    private boolean useGlobalCache;
    private boolean embedFonts;
    private ITextFontRegistry registry;

    public BaseFontSupport(ITextFontRegistry registry) {
        this(registry, "UTF-8");
    }

    public BaseFontSupport(ITextFontRegistry registry, String defaultEncoding) {
        this.registry = registry;
        this.defaultEncoding = defaultEncoding;
        ExtendedConfiguration extendedConfig = LibFontBoot.getInstance().getExtendedConfig();
        this.useGlobalCache = extendedConfig.getBoolProperty("org.pentaho.reporting.libraries.fonts.itext.UseGlobalFontCache");
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        if (defaultEncoding == null) {
            throw new NullPointerException("DefaultEncoding is null.");
        }
        this.defaultEncoding = defaultEncoding;
    }

    public boolean isEmbedFonts() {
        return this.embedFonts;
    }

    public void setEmbedFonts(boolean embedFonts) {
        this.embedFonts = embedFonts;
    }

    public void close() {
        this.baseFonts.clear();
    }

    public BaseFont createBaseFont(String logicalName, boolean bold, boolean italic, String encoding, boolean embedded) throws BaseFontCreateException {
        return this.createBaseFontRecord(logicalName, bold, italic, encoding, embedded).getBaseFont();
    }

    public BaseFontRecord createBaseFontRecord(String logicalName, boolean bold, boolean italic, String encoding, boolean embedded) throws BaseFontCreateException {
        String stringEncoding;
        String fontKey;
        block22: {
            if (logicalName == null) {
                throw new NullPointerException("Font definition is null.");
            }
            if (encoding == null) {
                encoding = this.getDefaultEncoding();
            }
            fontKey = FontMappingUtility.isCourier(logicalName) ? "Courier" : (FontMappingUtility.isSymbol(logicalName) ? "Symbol" : (FontMappingUtility.isSerif(logicalName) ? "Times" : (FontMappingUtility.isSansSerif(logicalName) ? "Helvetica" : logicalName)));
            if ("utf-8".equalsIgnoreCase(encoding)) {
                stringEncoding = "utf-8";
                encoding = "Identity-H";
            } else if ("utf-16".equalsIgnoreCase(encoding)) {
                stringEncoding = "utf-16";
                encoding = "Identity-H";
            } else {
                stringEncoding = encoding.equalsIgnoreCase("Identity-H") || encoding.equalsIgnoreCase("Identity-V") ? "utf-8" : encoding;
            }
            try {
                FontFamily registryFontFamily = this.registry.getFontFamily(fontKey);
                FontRecord registryFontRecord = null;
                if (registryFontFamily != null && (registryFontRecord = registryFontFamily.getFontRecord(bold, italic)) instanceof CompoundFontRecord) {
                    CompoundFontRecord cfr = (CompoundFontRecord)registryFontRecord;
                    registryFontRecord = cfr.getBase();
                }
                if (registryFontRecord != null) {
                    if (!(registryFontRecord instanceof ITextBuiltInFontRecord)) {
                        BaseFontRecord fontRecord;
                        FontSource source;
                        boolean embeddedOverride = embedded;
                        if (embedded && registryFontRecord instanceof FontSource && !(source = (FontSource)registryFontRecord).isEmbeddable()) {
                            logger.warn((Object)("License of font forbids embedded usage for font: " + fontKey));
                            embeddedOverride = false;
                        }
                        if ((fontRecord = this.createFontFromTTF(registryFontRecord, bold, italic, encoding, stringEncoding, embeddedOverride)) != null) {
                            return fontRecord;
                        }
                    } else {
                        ITextBuiltInFontRecord buildInFontRecord = (ITextBuiltInFontRecord)registryFontRecord;
                        String fontName = buildInFontRecord.getFullName();
                        BaseFontRecord fontRecord = this.getFromCache(fontName, encoding, embedded);
                        if (fontRecord != null) {
                            return fontRecord;
                        }
                        fontRecord = this.getFromCache(fontName, stringEncoding, embedded);
                        if (fontRecord != null) {
                            return fontRecord;
                        }
                        BaseFont f = BaseFont.createFont((String)fontName, (String)stringEncoding, (boolean)embedded, (boolean)this.useGlobalCache, null, null);
                        if (f != null) {
                            fontRecord = new BaseFontRecord(fontName, false, embedded, f, bold, italic);
                            this.putToCache(fontRecord);
                            return fontRecord;
                        }
                    }
                }
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("BaseFont.createFont failed. Key = " + fontKey + ": " + e.getMessage()), (Throwable)e);
                }
                if (!logger.isWarnEnabled()) break block22;
                logger.warn((Object)("BaseFont.createFont failed. Key = " + fontKey + ": " + e.getMessage()), (Throwable)e);
            }
        }
        try {
            BaseFontRecord fontRecord = this.getFromCache("Helvetica", stringEncoding, embedded);
            if (fontRecord != null) {
                this.putToCache(new BaseFontRecordKey(fontKey, encoding, embedded), fontRecord);
                return fontRecord;
            }
            BaseFont f = BaseFont.createFont((String)"Helvetica", (String)stringEncoding, (boolean)embedded, (boolean)this.useGlobalCache, null, null);
            if (f != null) {
                fontRecord = new BaseFontRecord("Helvetica", false, embedded, f, bold, italic);
                this.putToCache(fontRecord);
                this.putToCache(new BaseFontRecordKey(fontKey, encoding, embedded), fontRecord);
                return fontRecord;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"BaseFont.createFont for FALLBACK failed.", (Throwable)e);
            throw new BaseFontCreateException("Null font = " + fontKey);
        }
        throw new BaseFontCreateException("BaseFont creation failed, null font: " + fontKey);
    }

    private BaseFontRecord createFontFromTTF(FontRecord fontRecord, boolean bold, boolean italic, String encoding, String stringEncoding, boolean embedded) throws DocumentException {
        BaseFont f;
        String rawFilename;
        if (fontRecord instanceof TrueTypeFontRecord) {
            TrueTypeFontRecord ttfRecord = (TrueTypeFontRecord)fontRecord;
            rawFilename = ttfRecord.getCollectionIndex() >= 0 ? ttfRecord.getFontSource() + ',' + ttfRecord.getCollectionIndex() : ttfRecord.getFontSource();
        } else if (fontRecord instanceof FontSource) {
            FontSource source = (FontSource)fontRecord;
            rawFilename = source.getFontSource();
        } else {
            return null;
        }
        String filename = !fontRecord.isBold() && bold && !fontRecord.isItalic() && italic ? rawFilename + ",BoldItalic" : (!fontRecord.isBold() && bold ? rawFilename + ",Bold" : (!fontRecord.isItalic() && italic ? rawFilename + ",Italic" : rawFilename));
        BaseFontRecord fontRec = this.getFromCache(filename, encoding, embedded);
        if (fontRec != null) {
            return fontRec;
        }
        try {
            try {
                f = BaseFont.createFont((String)filename, (String)encoding, (boolean)embedded, (boolean)false, null, null);
            }
            catch (DocumentException e) {
                f = BaseFont.createFont((String)filename, (String)stringEncoding, (boolean)embedded, (boolean)false, null, null);
            }
        }
        catch (IOException ioe) {
            throw new DocumentException("Failed to read the font: " + ioe);
        }
        BaseFontRecord record = new BaseFontRecord(filename, true, embedded, f, fontRecord.isBold(), fontRecord.isItalic());
        this.putToCache(record);
        return record;
    }

    private void putToCache(BaseFontRecord record) {
        BaseFontRecordKey key = record.createKey();
        this.putToCache(key, record);
    }

    private void putToCache(BaseFontRecordKey key, BaseFontRecord record) {
        this.baseFonts.put(key, record);
    }

    private BaseFontRecord getFromCache(String fileName, String encoding, boolean embedded) {
        BaseFontRecordKey key = new BaseFontRecordKey(fileName, encoding, embedded);
        BaseFontRecord r = (BaseFontRecord)this.baseFonts.get(key);
        if (r != null) {
            return r;
        }
        return null;
    }

    public BaseFont awtToPdf(Font font) {
        boolean embed = this.isEmbedFonts();
        String encoding = this.getDefaultEncoding();
        try {
            return this.createBaseFont(font.getName(), font.isBold(), font.isItalic(), encoding, embed);
        }
        catch (Exception e) {
            throw new BaseFontCreateException("Unable to create font: " + font, e);
        }
    }

    public Font pdfToAwt(BaseFont font, int size) {
        String logicalName = this.getFontName(font);
        boolean bold = false;
        boolean italic = false;
        if (StringUtils.endsWithIgnoreCase((String)logicalName, (String)"bolditalic")) {
            bold = true;
            italic = true;
        } else if (StringUtils.endsWithIgnoreCase((String)logicalName, (String)"bold")) {
            bold = true;
        } else if (StringUtils.endsWithIgnoreCase((String)logicalName, (String)"italic")) {
            italic = true;
        }
        int style = 0;
        if (bold) {
            style |= 1;
        }
        if (italic) {
            style |= 2;
        }
        return new Font(logicalName, style, size);
    }

    private String getFontName(BaseFont font) {
        String[][] names = font.getFullFontName();
        int nameCount = names.length;
        if (nameCount == 1) {
            return names[0][3];
        }
        String nameExtr = null;
        for (int k = 0; k < nameCount; ++k) {
            String[] name = names[k];
            if ("1".equals(name[0]) && "0".equals(name[1])) {
                nameExtr = name[3];
                continue;
            }
            if (!"1033".equals(name[2])) continue;
            nameExtr = name[3];
            break;
        }
        if (nameExtr != null) {
            return nameExtr;
        }
        return names[0][3];
    }
}

