/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.util;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.TypeDescription;
import org.apache.orc.util.BloomFilter;
import org.apache.orc.util.BloomFilterUtf8;

public class BloomFilterIO {
    private BloomFilterIO() {
    }

    public static BloomFilter deserialize(OrcProto.Stream.Kind kind, OrcFile.WriterVersion fileVersion, TypeDescription.Category type, OrcProto.BloomFilter bloomFilter) {
        if (bloomFilter == null) {
            return null;
        }
        int numFuncs = bloomFilter.getNumHashFunctions();
        switch (kind) {
            case BLOOM_FILTER: {
                long[] values = new long[bloomFilter.getBitsetCount()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = bloomFilter.getBitset(i);
                }
                if (fileVersion.includes(OrcFile.WriterVersion.HIVE_12055) && (type == TypeDescription.Category.STRING || type == TypeDescription.Category.CHAR || type == TypeDescription.Category.VARCHAR)) {
                    return new BloomFilterUtf8(values, numFuncs);
                }
                return new BloomFilter(values, numFuncs);
            }
            case BLOOM_FILTER_UTF8: {
                ByteString bits = bloomFilter.getUtf8Bitset();
                long[] values = new long[bits.size() / 8];
                bits.asReadOnlyByteBuffer().order(ByteOrder.LITTLE_ENDIAN).asLongBuffer().get(values);
                return new BloomFilterUtf8(values, numFuncs);
            }
        }
        throw new IllegalArgumentException("Unknown bloom filter kind " + (Object)((Object)kind));
    }

    public static void serialize(OrcProto.BloomFilter.Builder builder, BloomFilter bloomFilter) {
        builder.clear();
        builder.setNumHashFunctions(bloomFilter.getNumHashFunctions());
        long[] bitset = bloomFilter.getBitSet();
        if (bloomFilter instanceof BloomFilterUtf8) {
            ByteBuffer buffer = ByteBuffer.allocate(bitset.length * 8);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.asLongBuffer().put(bitset);
            builder.setUtf8Bitset(ByteString.copyFrom((ByteBuffer)buffer));
        } else {
            for (int i = 0; i < bitset.length; ++i) {
                builder.addBitset(bitset[i]);
            }
        }
    }
}

