/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.io.IOException;
import org.apache.pig.parser.SourceLocation;

public class PigException
extends IOException {
    static final long serialVersionUID = 1L;
    public static final byte INPUT = 2;
    public static final byte BUG = 4;
    public static final byte USER_ENVIRONMENT = 8;
    public static final byte REMOTE_ENVIRONMENT = 16;
    public static final byte ERROR = -1;
    protected int errorCode = 0;
    protected byte errorSource = (byte)4;
    protected boolean retriable = false;
    protected String detailedMessage = null;
    protected boolean markedAsShowToUser = false;
    protected SourceLocation sourceLocation = null;

    public static boolean isInput(byte errSource) {
        return (errSource & 2) != 0;
    }

    public static boolean isBug(byte errSource) {
        return (errSource & 4) != 0;
    }

    public static boolean isUserEnvironment(byte errSource) {
        return (errSource & 8) != 0;
    }

    public static boolean isRemoteEnvironment(byte errSource) {
        return (errSource & 0x10) != 0;
    }

    public static byte determineErrorSource(int errCode) {
        if (errCode >= 100 && errCode <= 1999) {
            return 2;
        }
        if (errCode >= 2000 && errCode <= 2999) {
            return 4;
        }
        if (errCode >= 3000 && errCode <= 4999) {
            return 8;
        }
        if (errCode >= 5000 && errCode <= 6999) {
            return 16;
        }
        return -1;
    }

    public PigException() {
    }

    public PigException(String message) {
        super(message);
    }

    public PigException(String message, SourceLocation location) {
        super(message);
        this.sourceLocation = location;
    }

    public PigException(Throwable cause) {
        super(cause);
    }

    public PigException(String message, Throwable cause) {
        super(message, cause);
    }

    public PigException(String message, int errCode) {
        this(message);
        this.errorCode = errCode;
    }

    public PigException(String message, int errCode, SourceLocation location) {
        this(message, location);
        this.errorCode = errCode;
    }

    public PigException(String message, int errCode, Throwable cause) {
        this(message, cause);
        this.errorCode = errCode;
    }

    public PigException(String message, int errCode, Throwable cause, SourceLocation location) {
        this(message, cause);
        this.errorCode = errCode;
        this.sourceLocation = location;
    }

    public PigException(String message, int errCode, byte errSrc) {
        this(message, errCode);
        this.errorSource = errSrc;
    }

    public PigException(String message, int errCode, byte errSrc, SourceLocation location) {
        this(message, errCode, location);
        this.errorSource = errSrc;
    }

    public PigException(String message, int errCode, byte errSrc, Throwable cause) {
        this(message, errCode, errSrc, false, null, cause);
    }

    public PigException(String message, int errCode, byte errSrc, Throwable cause, SourceLocation location) {
        this(message, errCode, errSrc, false, null, cause, location);
    }

    public PigException(String message, int errCode, boolean retry) {
        this(message, errCode);
        this.retriable = retry;
    }

    public PigException(String message, int errCode, byte errSrc, boolean retry) {
        this(message, errCode, errSrc);
        this.retriable = retry;
    }

    public PigException(String message, int errCode, byte errSrc, boolean retry, String detailedMsg) {
        this(message, errCode, errSrc, retry);
        this.detailedMessage = detailedMsg;
    }

    public PigException(String message, int errCode, byte errSrc, boolean retry, String detailedMsg, SourceLocation location) {
        this(message, errCode, errSrc, retry);
        this.detailedMessage = detailedMsg;
        this.sourceLocation = location;
    }

    public PigException(String message, int errCode, byte errSrc, boolean retry, String detailedMsg, Throwable cause) {
        super(message, cause);
        this.errorCode = errCode;
        this.errorSource = errSrc;
        this.retriable = retry;
        this.detailedMessage = detailedMsg;
    }

    public PigException(String message, int errCode, byte errSrc, boolean retry, String detailedMsg, Throwable cause, SourceLocation location) {
        super(message, cause);
        this.errorCode = errCode;
        this.errorSource = errSrc;
        this.retriable = retry;
        this.detailedMessage = detailedMsg;
        this.sourceLocation = location;
    }

    public boolean retriable() {
        return this.retriable;
    }

    public void setRetriable(boolean retry) {
        this.retriable = retry;
    }

    public byte getErrorSource() {
        return this.errorSource;
    }

    public void setErrorSource(byte src) {
        this.errorSource = src;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int code) {
        this.errorCode = code;
    }

    public String getDetailedMessage() {
        return this.detailedMessage;
    }

    public void setDetailedMessage(String detailMsg) {
        this.detailedMessage = detailMsg;
    }

    public boolean getMarkedAsShowToUser() {
        return this.markedAsShowToUser;
    }

    public void setMarkedAsShowToUser(boolean showToUser) {
        this.markedAsShowToUser = showToUser;
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public void setSourceLocation(SourceLocation location) {
        this.sourceLocation = location;
    }

    @Override
    public String toString() {
        String s = this.getClass().getName();
        String message = this.getLocalizedMessage();
        return message != null ? s + ": " + "ERROR " + this.getErrorCode() + ": " + message : s;
    }
}

