/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.streaming;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.pig.StreamToPig;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.BufferedPositionedInputStream;
import org.apache.pig.impl.streaming.OutputHandler;
import org.apache.pig.impl.streaming.StreamingCommand;

public class FileOutputHandler
extends OutputHandler {
    private String fileName;

    public FileOutputHandler(StreamingCommand.HandleSpec handleSpec) throws ExecException {
        this.fileName = handleSpec.name;
        this.deserializer = (StreamToPig)PigContext.instantiateFuncFromSpec(handleSpec.spec);
    }

    @Override
    public OutputHandler.OutputType getOutputType() {
        return OutputHandler.OutputType.ASYNCHRONOUS;
    }

    @Override
    public void bindTo(String fileName, BufferedPositionedInputStream is, long offset, long end) throws IOException {
        File file = new File(this.fileName);
        BufferedPositionedInputStream fileInStream = new BufferedPositionedInputStream(new FileInputStream(file));
        super.bindTo(this.fileName, fileInStream, 0L, file.length());
    }
}

