/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements;

import java.awt.Color;
import org.pentaho.reporting.engine.classic.core.style.BorderStyle;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.ColorConverter;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class BorderEdgeReadHandler
extends AbstractXmlReadHandler {
    private BorderStyle borderType;
    private float width;
    private Color color;

    protected void startParsing(Attributes attrs) throws SAXException {
        this.width = ParserUtil.parseFloat((String)attrs.getValue(this.getUri(), "width"), (String)"Failed to parse width", (Locator)this.getLocator());
        this.color = ColorConverter.getObject(attrs.getValue(this.getUri(), "color"));
        this.borderType = this.parseBorderStyle(attrs.getValue(this.getUri(), "borderType"));
    }

    private BorderStyle parseBorderStyle(String s) {
        if ("HIDDEN".equals(s)) {
            return BorderStyle.HIDDEN;
        }
        if ("DOTTED".equals(s)) {
            return BorderStyle.DOTTED;
        }
        if ("DASHED".equals(s)) {
            return BorderStyle.DASHED;
        }
        if ("SOLID".equals(s)) {
            return BorderStyle.SOLID;
        }
        if ("DOUBLE".equals(s)) {
            return BorderStyle.DOUBLE;
        }
        if ("DOT_DASH".equals(s)) {
            return BorderStyle.DOT_DASH;
        }
        if ("DOT_DOT_DASH".equals(s)) {
            return BorderStyle.DOT_DOT_DASH;
        }
        if ("WAVE".equals(s)) {
            return BorderStyle.WAVE;
        }
        if ("GROOVE".equals(s)) {
            return BorderStyle.GROOVE;
        }
        if ("RIDGE".equals(s)) {
            return BorderStyle.RIDGE;
        }
        if ("INSET".equals(s)) {
            return BorderStyle.INSET;
        }
        if ("OUTSET".equals(s)) {
            return BorderStyle.OUTSET;
        }
        return BorderStyle.NONE;
    }

    public BorderStyle getBorderType() {
        return this.borderType;
    }

    public float getWidth() {
        return this.width;
    }

    public Color getColor() {
        return this.color;
    }

    public Object getObject() throws SAXException {
        return null;
    }
}

