/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.sequence;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.designtime.DefaultDesignTimeContext;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataSetQuery;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.NamedQueryModel;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.QueryAddAction;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.QueryNameListCellRenderer;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.QueryNameTextFieldDocumentListener;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.QueryRemoveAction;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.QuerySelectedHandler;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.Sequence;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.SequenceDataFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.SequenceDescription;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.SequenceRegistry;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.background.DataPreviewDialog;
import org.pentaho.reporting.libraries.designtime.swing.background.PreviewWorker;
import org.pentaho.reporting.ui.datasources.sequence.Messages;
import org.pentaho.reporting.ui.datasources.sequence.SequenceEditor;
import org.pentaho.reporting.ui.datasources.sequence.SequencePreviewWorker;

public class SequenceDataSourceEditor
extends CommonDialog {
    private JTextField queryNameTextField;
    private JList queryNameList;
    private SequenceEditor sequenceEditor;
    private NamedQueryModel<Sequence> queries;
    private DesignTimeContext designTimeContext;
    private SequenceRegistry registry;
    private PreviewAction previewAction;
    private QuerySelectedHandler querySelectedHandler;

    public SequenceDataSourceEditor() {
        this.init();
    }

    public SequenceDataSourceEditor(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public SequenceDataSourceEditor(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    private SequenceDescription getDefaultSequence() {
        SequenceDescription[] sequences = this.registry.getSequences();
        if (sequences.length == 0) {
            return null;
        }
        return sequences[0];
    }

    protected void init() {
        this.registry = new SequenceRegistry();
        this.queries = new SequenceQueryModel();
        this.previewAction = new PreviewAction();
        QueryNameHandler queryNameHandler = new QueryNameHandler(this.queries);
        this.queryNameList = new JList(this.queries.getQueries());
        this.queryNameList.setSelectionMode(0);
        this.queryNameList.setVisibleRowCount(5);
        this.queryNameList.setCellRenderer(new QueryNameListCellRenderer());
        this.querySelectedHandler = new QuerySelectedHandler(this.queries, this.queryNameList);
        this.queryNameTextField = new JTextField(null, 0);
        this.queryNameTextField.setColumns(35);
        this.queryNameTextField.getDocument().addDocumentListener((DocumentListener)((Object)queryNameHandler));
        this.queryNameTextField.setEnabled(false);
        this.sequenceEditor = new SequenceEditor();
        this.sequenceEditor.addPropertyChangeListener("sequence", new SequenceChangeHandler());
        this.setTitle(Messages.getString("SequenceDataSourceEditor.Title"));
        super.init();
    }

    protected String getDialogId() {
        return "SequenceDataSourceEditor";
    }

    protected Component createContentPane() {
        JPanel namePanel = new JPanel(new BorderLayout());
        namePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        namePanel.add("North", new JLabel(Messages.getString("SequenceDataSourceEditor.QueryName")));
        namePanel.add("Center", this.queryNameTextField);
        JPanel queryConfigPane = new JPanel(new BorderLayout());
        queryConfigPane.add((Component)this.createQuerySelectionPanel(), "North");
        queryConfigPane.add((Component)namePanel, "Center");
        JPanel previewButtonPanel = new JPanel(new FlowLayout(2));
        previewButtonPanel.add(new JButton(this.previewAction));
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)queryConfigPane, "North");
        contentPane.add((Component)this.sequenceEditor, "Center");
        contentPane.add((Component)previewButtonPanel, "South");
        return contentPane;
    }

    private JPanel createQuerySelectionPanel() {
        QueryRemoveAction removeQueryAction = new QueryRemoveAction(this.queries);
        JPanel queryListButtonsPanel = new JPanel(new FlowLayout(2));
        queryListButtonsPanel.add((Component)new BorderlessButton((Action)new QueryAddAction(this.queries)));
        queryListButtonsPanel.add((Component)new BorderlessButton((Action)removeQueryAction));
        JPanel queryListDetailsPanel = new JPanel(new BorderLayout());
        queryListDetailsPanel.add((Component)new JLabel(Messages.getString("SequenceDataSourceEditor.QueryDetailsLabel")), "West");
        queryListDetailsPanel.add((Component)queryListButtonsPanel, "East");
        JPanel queryListPanel = new JPanel(new BorderLayout());
        queryListPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        queryListPanel.add("North", queryListDetailsPanel);
        queryListPanel.add("Center", new JScrollPane(this.queryNameList));
        return queryListPanel;
    }

    public SequenceDataFactory performConfiguration(DesignTimeContext context, SequenceDataFactory dataFactory, String selectedQuery) {
        this.designTimeContext = context;
        if (this.designTimeContext != null) {
            this.sequenceEditor.applyLocaleSettings(context.getLocaleSettings());
        }
        if (dataFactory != null) {
            String[] queryNames = dataFactory.getQueryNames();
            for (int i = 0; i < queryNames.length; ++i) {
                String queryName = queryNames[i];
                Sequence query = dataFactory.getSequence(queryName);
                this.queries.addQuery(queryName, (Object)query);
            }
        }
        this.queries.setSelectedQuery(selectedQuery);
        if (!this.performEdit()) {
            return null;
        }
        this.sequenceEditor.stopEditing();
        SequenceDataFactory retval = new SequenceDataFactory();
        for (DataSetQuery query : this.queries.getQueries()) {
            retval.addSequence(query.getQueryName(), (Sequence)query.getQuery());
        }
        return retval;
    }

    public static void main(String[] args) {
        ClassicEngineBoot.getInstance().start();
        SequenceDataSourceEditor ed = new SequenceDataSourceEditor();
        ed.performConfiguration((DesignTimeContext)new DefaultDesignTimeContext((AbstractReportDefinition)new MasterReport()), null, null);
    }

    private class SequenceQueryModel
    extends NamedQueryModel<Sequence> {
        private SequenceQueryModel() {
        }

        protected Sequence createDefaultObject() {
            SequenceDescription defaultSequence = SequenceDataSourceEditor.this.getDefaultSequence();
            if (defaultSequence == null) {
                return null;
            }
            return defaultSequence.newInstance();
        }

        protected void setQuerySelected(boolean querySelected) {
            super.setQuerySelected(querySelected);
            SequenceDataSourceEditor.this.queryNameTextField.setEnabled(querySelected);
            SequenceDataSourceEditor.this.sequenceEditor.setEnabled(querySelected);
        }

        public void setSelectedDataSetQuery(DataSetQuery<Sequence> sequenceDataSetQuery) {
            SequenceDataSourceEditor.this.sequenceEditor.stopEditing();
            super.setSelectedDataSetQuery(sequenceDataSetQuery);
        }
    }

    private class SequenceChangeHandler
    implements PropertyChangeListener {
        private SequenceChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DataSetQuery selectedQuery = SequenceDataSourceEditor.this.queries.getQueries().getSelectedQuery();
            if (selectedQuery != null) {
                selectedQuery.setQuery((Object)SequenceDataSourceEditor.this.sequenceEditor.getSequence());
            }
        }
    }

    private class PreviewAction
    extends AbstractAction {
        private PreviewAction() {
            this.putValue("Name", Messages.getString("SequenceDataSourceEditor.Preview.Name"));
        }

        @Override
        public void actionPerformed(ActionEvent aEvt) {
            try {
                Sequence query = SequenceDataSourceEditor.this.sequenceEditor.getSequence();
                if (query == null) {
                    return;
                }
                DataPreviewDialog previewDialog = new DataPreviewDialog((Dialog)((Object)SequenceDataSourceEditor.this));
                SequencePreviewWorker worker = new SequencePreviewWorker(query, SequenceDataSourceEditor.this.designTimeContext);
                previewDialog.showData((PreviewWorker)worker);
                ReportDataFactoryException factoryException = worker.getException();
                if (factoryException != null) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)SequenceDataSourceEditor.this), (String)Messages.getString("SequenceDataSourceEditor.PreviewError.Title"), (String)Messages.getString("SequenceDataSourceEditor.PreviewError.Message"), (Exception)factoryException);
                }
            }
            catch (Exception e) {
                ExceptionDialog.showExceptionDialog((Component)((Object)SequenceDataSourceEditor.this), (String)Messages.getString("SequenceDataSourceEditor.PreviewError.Title"), (String)Messages.getString("SequenceDataSourceEditor.PreviewError.Message"), (Exception)e);
            }
        }
    }

    private class QueryNameHandler
    extends QueryNameTextFieldDocumentListener<Sequence> {
        private QueryNameHandler(NamedQueryModel<Sequence> dialogModel) {
            super(dialogModel);
        }

        protected void setEditorQuery(DataSetQuery<Sequence> dataSetQuery) {
            if (dataSetQuery == null) {
                SequenceDataSourceEditor.this.queryNameTextField.setText(null);
                SequenceDataSourceEditor.this.sequenceEditor.setSequence(null);
                return;
            }
            SequenceDataSourceEditor.this.queryNameTextField.setText(dataSetQuery.getQueryName());
            SequenceDataSourceEditor.this.sequenceEditor.setSequence((Sequence)dataSetQuery.getQuery());
        }
    }
}

