/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.table;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.designtime.DefaultDesignTimeContext;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataSetQuery;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.NamedQueryModel;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.QueryAddAction;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.QueryNameListCellRenderer;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.QueryNameTextFieldDocumentListener;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.QueryRemoveAction;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.QuerySelectedHandler;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.background.BackgroundCancellableProcessHelper;
import org.pentaho.reporting.libraries.designtime.swing.background.CancelListener;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.CommonFileChooser;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.FileChooserService;
import org.pentaho.reporting.ui.datasources.table.ImportFromFileTask;
import org.pentaho.reporting.ui.datasources.table.Messages;
import org.pentaho.reporting.ui.datasources.table.TableEditorPanel;

public class TableDataSourceEditor
extends CommonDialog {
    private JTextField queryNameTextField;
    private TableEditorPanel table;
    private JList queryNameList;
    private TableQueryModel queries;
    private JCheckBox useFirstRowAsHeader;
    private ImportAction importAction;
    private DesignTimeContext designTimeContext;

    public TableDataSourceEditor(Dialog aOwner) {
        super(aOwner);
        this.init();
    }

    public TableDataSourceEditor(Frame aOwner) {
        super(aOwner);
        this.init();
    }

    public TableDataSourceEditor() {
        this.init();
    }

    protected void init() {
        this.queries = new TableQueryModel();
        QueryNameHandler queryNameHandler = new QueryNameHandler(this.queries);
        this.queryNameList = new JList(this.queries.getQueries());
        this.queryNameList.setSelectionMode(0);
        this.queryNameList.setVisibleRowCount(5);
        this.queryNameList.setCellRenderer(new QueryNameListCellRenderer());
        this.queryNameTextField = new JTextField(null, 0);
        this.queryNameTextField.setColumns(35);
        this.queryNameTextField.getDocument().addDocumentListener((DocumentListener)((Object)queryNameHandler));
        this.queryNameTextField.setEnabled(false);
        QuerySelectedHandler querySelectedHandler = new QuerySelectedHandler((NamedQueryModel)this.queries, this.queryNameList);
        this.table = new TableEditorPanel();
        this.table.addChangeListener(new TableUpdateHandler());
        this.importAction = new ImportAction();
        this.useFirstRowAsHeader = new JCheckBox(Messages.getString("TableDataSourceEditor.UseFirstRowAsHeader"));
        this.useFirstRowAsHeader.setEnabled(false);
        this.useFirstRowAsHeader.setSelected(true);
        this.setTitle(Messages.getString("TableDataSourceEditor.Title"));
        super.init();
    }

    protected String getDialogId() {
        return "TableDataSourceEditor";
    }

    protected Component createContentPane() {
        JPanel namePanel = new JPanel(new BorderLayout());
        namePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        namePanel.add("North", new JLabel(Messages.getString("TableDataSourceEditor.QueryName")));
        namePanel.add("Center", this.queryNameTextField);
        JPanel leftButtonsPanel = new JPanel(new FlowLayout(0, 5, 5));
        leftButtonsPanel.add(this.useFirstRowAsHeader);
        leftButtonsPanel.add(new JButton(this.importAction));
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        buttonsPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY));
        buttonsPanel.add((Component)leftButtonsPanel, "West");
        JPanel queryConfigPane = new JPanel(new BorderLayout());
        queryConfigPane.add((Component)this.createQuerySelectionPanel(), "North");
        queryConfigPane.add((Component)namePanel, "Center");
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)queryConfigPane, "North");
        contentPane.add((Component)this.table, "Center");
        contentPane.add((Component)buttonsPanel, "South");
        return contentPane;
    }

    private JPanel createQuerySelectionPanel() {
        QueryRemoveAction removeQueryAction = new QueryRemoveAction((NamedQueryModel)this.queries);
        JPanel queryListButtonsPanel = new JPanel(new FlowLayout(2));
        queryListButtonsPanel.add((Component)new BorderlessButton((Action)new QueryAddAction((NamedQueryModel)this.queries)));
        queryListButtonsPanel.add((Component)new BorderlessButton((Action)removeQueryAction));
        JPanel queryListDetailsPanel = new JPanel(new BorderLayout());
        queryListDetailsPanel.add((Component)new JLabel(Messages.getString("TableDataSourceEditor.QueryDetailsLabel")), "West");
        queryListDetailsPanel.add((Component)queryListButtonsPanel, "East");
        JPanel queryListPanel = new JPanel(new BorderLayout());
        queryListPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        queryListPanel.add("North", queryListDetailsPanel);
        queryListPanel.add("Center", new JScrollPane(this.queryNameList));
        return queryListPanel;
    }

    public TableDataFactory performConfiguration(DesignTimeContext designTimeContext, TableDataFactory dataFactory, String selectedQuery) {
        if (designTimeContext == null) {
            throw new NullPointerException();
        }
        this.designTimeContext = designTimeContext;
        this.table.applyLocaleSettings(designTimeContext.getLocaleSettings());
        if (dataFactory != null) {
            String[] queryNames = dataFactory.getQueryNames();
            for (int i = 0; i < queryNames.length; ++i) {
                String queryName = queryNames[i];
                TableModel query = dataFactory.getTable(queryName);
                this.queries.addQuery(queryName, query);
            }
        }
        this.queries.setSelectedQuery(selectedQuery);
        if (!this.performEdit()) {
            return null;
        }
        this.table.stopEditing();
        TableDataFactory retval = new TableDataFactory();
        for (DataSetQuery query : this.queries.getQueries()) {
            retval.addTable(query.getQueryName(), (TableModel)query.getQuery());
        }
        return retval;
    }

    protected void updateComponents() {
        boolean querySelected = this.queryNameList.getSelectedIndex() != -1;
        this.queryNameTextField.setEnabled(querySelected);
        this.table.setEnabled(querySelected);
        this.importAction.setEnabled(querySelected);
        this.useFirstRowAsHeader.setEnabled(querySelected);
    }

    public void importComplete(TypedTableModel tableModel) {
        this.table.setTableEditorModel((TableModel)tableModel);
    }

    public void importFailed(Exception e) {
        this.designTimeContext.error(e);
    }

    public static void main(String[] args) {
        ClassicEngineBoot.getInstance().start();
        TableDataSourceEditor ed = new TableDataSourceEditor();
        ed.performConfiguration((DesignTimeContext)new DefaultDesignTimeContext((AbstractReportDefinition)new MasterReport()), null, null);
    }

    private class TableQueryModel
    extends NamedQueryModel<TableModel> {
        private TableQueryModel() {
        }

        protected TableModel createDefaultObject() {
            TypedTableModel defaultTableModel = new TypedTableModel();
            defaultTableModel.addColumn(Messages.getString("TableDataSourceEditor.IDColumn"), String.class);
            defaultTableModel.addColumn(Messages.getString("TableDataSourceEditor.ValueColumn"), String.class);
            defaultTableModel.addRow(new Object[0]);
            return defaultTableModel;
        }

        public void setSelectedDataSetQuery(DataSetQuery<TableModel> tableModelDataSetQuery) {
            TableDataSourceEditor.this.table.stopEditing();
            super.setSelectedDataSetQuery(tableModelDataSetQuery);
        }

        protected void setQuerySelected(boolean querySelected) {
            super.setQuerySelected(querySelected);
            TableDataSourceEditor.this.updateComponents();
        }
    }

    private class TableUpdateHandler
    implements ChangeListener {
        private TableUpdateHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            DataSetQuery selectedQuery = TableDataSourceEditor.this.queries.getQueries().getSelectedQuery();
            if (selectedQuery != null) {
                selectedQuery.setQuery((Object)TableDataSourceEditor.this.table.getTableEditorModel());
            }
        }
    }

    private class QueryNameHandler
    extends QueryNameTextFieldDocumentListener<TableModel> {
        private QueryNameHandler(NamedQueryModel<TableModel> dialogModel) {
            super(dialogModel);
        }

        protected void setEditorQuery(DataSetQuery<TableModel> dataSetQuery) {
            if (dataSetQuery == null) {
                TableDataSourceEditor.this.queryNameTextField.setText(null);
                TableDataSourceEditor.this.table.setTableEditorModel(null);
                return;
            }
            TableDataSourceEditor.this.queryNameTextField.setText(dataSetQuery.getQueryName());
            TableDataSourceEditor.this.table.setTableEditorModel((TableModel)dataSetQuery.getQuery());
        }
    }

    private class ImportAction
    extends AbstractAction {
        private ImportAction() {
            this.setEnabled(false);
            URL resource = TableDataSourceEditor.class.getResource("/org/pentaho/reporting/ui/datasources/table/resources/Spreadsheet.png");
            if (resource != null) {
                this.putValue("SmallIcon", new ImageIcon(resource));
            }
            this.putValue("Name", Messages.getString("TableDataSourceEditor.ImportSpreadsheet.Name"));
            this.putValue("ShortDescription", Messages.getString("TableDataSourceEditor.ImportSpreadsheet.Description"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileFilter[] fileFilters = new FileFilter[]{new FilesystemFilter(new String[]{".xls", ".xlsx"}, Messages.getString("TableDataSourceEditor.ExcelFileDescription"), true)};
            CommonFileChooser fileChooser = FileChooserService.getInstance().getFileChooser("xls");
            fileChooser.setFilters(fileFilters);
            if (!fileChooser.showDialog((Component)((Object)TableDataSourceEditor.this), 0)) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            ImportFromFileTask importFromFileTask = new ImportFromFileTask(file, TableDataSourceEditor.this.useFirstRowAsHeader.isSelected(), TableDataSourceEditor.this);
            Thread workerThread = new Thread(importFromFileTask);
            workerThread.setName("PRD-import-table-data-task");
            BackgroundCancellableProcessHelper.executeProcessWithCancelDialog((Thread)workerThread, (CancelListener)importFromFileTask, (Component)((Object)TableDataSourceEditor.this), (String)Messages.getString("TableDataSourceEditor.ImportSpeadsheet.TaskName"));
        }
    }
}

