/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization;

import com.google.common.base.Objects;

public class OptimizationImpactInfo {
    private String queryBeforeOptimization = "";
    private String queryAfterOptimization = "";
    private final String stepName;
    private boolean modified = false;
    private String errorMsg = "";

    public OptimizationImpactInfo(String stepName) {
        this.stepName = stepName;
    }

    public String getQueryBeforeOptimization() {
        return this.queryBeforeOptimization == null || this.queryBeforeOptimization.trim().length() == 0 ? "<no query>" : this.queryBeforeOptimization;
    }

    public void setQueryBeforeOptimization(String queryBeforeOptimization) {
        this.queryBeforeOptimization = queryBeforeOptimization;
    }

    public String getQueryAfterOptimization() {
        return this.queryAfterOptimization;
    }

    public void setQueryAfterOptimization(String queryAfterOptimization) {
        this.queryAfterOptimization = queryAfterOptimization;
    }

    public String getStepName() {
        return this.stepName;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(Exception ex) {
        this.errorMsg = (String)Objects.firstNonNull((Object)ex.getMessage(), (Object)ex.toString());
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("Step:  ").append(this.getStepName()).append("\n");
        if (this.getErrorMsg() == null || this.getErrorMsg().length() > 0) {
            builder.append("[ERROR]  ").append(this.getErrorMsg()).append("\n");
        }
        if (this.isModified()) {
            builder.append("Before:\n     ").append(this.getQueryBeforeOptimization()).append("\nAfter:\n     ").append(this.getQueryAfterOptimization());
        } else {
            builder.append("[NO MODIFICATION]\n").append("Query:\n     ").append(this.getQueryBeforeOptimization());
        }
        return builder.toString();
    }
}

