/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization.paramgen.ui;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ParameterGenerationFactory;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ui.ParameterGenerationController;
import org.pentaho.di.trans.dataservice.ui.DataServiceDialog;
import org.pentaho.di.trans.dataservice.ui.model.DataServiceModel;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.ui.xul.impl.XulEventHandler;

public class ParameterGenerationOverlay
implements DataServiceDialog.OptimizationOverlay {
    private static final String XUL_OVERLAY = "org/pentaho/di/trans/dataservice/optimization/paramgen/ui/param-gen-overlay.xul";
    private ParameterGenerationFactory factory;

    public ParameterGenerationOverlay(ParameterGenerationFactory factory) {
        this.factory = factory;
    }

    @Override
    public double getPriority() {
        return 1.0;
    }

    @Override
    public void apply(DataServiceDialog dialog) throws KettleException {
        DataServiceModel dialogModel = dialog.getModel();
        TransMeta transMeta = dialogModel.getTransMeta();
        ParameterGenerationController controller = this.factory.createController(dialogModel);
        dialog.applyOverlay(this, XUL_OVERLAY).addEventHandler((XulEventHandler)controller);
        controller.initBindings((List<String>)this.findSupportedSteps(transMeta).keySet().asList());
    }

    protected ImmutableMap<String, StepMeta> findSupportedSteps(TransMeta transMeta) {
        return FluentIterable.from((Iterable)transMeta.getSteps()).filter((Predicate)new Predicate<StepMeta>(){

            public boolean apply(StepMeta input) {
                return ParameterGenerationOverlay.this.factory.supportsStep(input);
            }
        }).uniqueIndex((Function)new Function<StepMeta, String>(){

            public String apply(StepMeta input) {
                return input.getName();
            }
        });
    }
}

