/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.resolvers;

import com.google.common.base.Function;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.sql.SQL;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceContext;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.optimization.PushDownOptimizationMeta;
import org.pentaho.di.trans.dataservice.optimization.cache.ServiceCacheFactory;
import org.pentaho.di.trans.dataservice.resolvers.DataServiceResolver;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.osgi.kettle.repository.locator.api.KettleRepositoryLocator;

public class TransientResolver
implements DataServiceResolver {
    public static final String DELIMITER = ":";
    public static final String PREFIX = "transient:";
    public static final String LOCAL = "local:";
    public static final String STREAMING = "streaming:";
    private KettleRepositoryLocator repositoryLocator;
    private DataServiceContext context;
    private ServiceCacheFactory cacheFactory;
    private LogLevel logLevel;
    private Supplier<Spoon> spoonSupplier;

    public TransientResolver(KettleRepositoryLocator repositoryLocator, DataServiceContext context, ServiceCacheFactory cacheFactory, LogLevel logLevel) {
        this(repositoryLocator, context, cacheFactory, logLevel, Spoon::getInstance);
    }

    public TransientResolver(KettleRepositoryLocator repositoryLocator, DataServiceContext context, ServiceCacheFactory cacheFactory, LogLevel logLevel, Supplier<Spoon> spoonSupplier) {
        this.repositoryLocator = repositoryLocator;
        this.context = context;
        this.cacheFactory = cacheFactory;
        this.logLevel = logLevel;
        this.spoonSupplier = spoonSupplier;
    }

    @Override
    public DataServiceMeta getDataService(String dataServiceName) {
        if (!TransientResolver.isTransient(dataServiceName)) {
            return null;
        }
        return this.createDataServiceMeta(dataServiceName);
    }

    @Override
    public List<String> getDataServiceNames(String dataServiceName) {
        ArrayList<String> dataServiceNames = new ArrayList<String>();
        if (TransientResolver.isTransient(dataServiceName)) {
            dataServiceNames.add(dataServiceName);
        }
        return dataServiceNames;
    }

    @Override
    public List<DataServiceMeta> getDataServices(String dataServiceName, Function<Exception, Void> logger) {
        ArrayList<DataServiceMeta> dataServiceMetas = new ArrayList<DataServiceMeta>();
        if (TransientResolver.isTransient(dataServiceName)) {
            dataServiceMetas.add(this.createDataServiceMeta(dataServiceName));
        }
        return dataServiceMetas;
    }

    @Override
    public DataServiceExecutor.Builder createBuilder(SQL sql) {
        DataServiceMeta dataServiceMeta = this.getDataService(sql.getServiceName());
        if (dataServiceMeta != null) {
            if (dataServiceMeta.isStreaming()) {
                return new DataServiceExecutor.Builder(sql, dataServiceMeta, this.context).rowLimit(dataServiceMeta.getRowLimit()).timeLimit(dataServiceMeta.getTimeLimit());
            }
            return new DataServiceExecutor.Builder(sql, dataServiceMeta, this.context).logLevel(this.logLevel);
        }
        return null;
    }

    private DataServiceMeta createDataServiceMeta(String dataServiceName) {
        String rowLimit;
        String stepName;
        String fileAndPath;
        boolean local = false;
        boolean streaming = false;
        try {
            String[] parts = this.splitTransient(dataServiceName);
            fileAndPath = TransientResolver.decode(parts[0].trim());
            stepName = TransientResolver.decode(parts[1].trim());
            if (stepName.startsWith("local:streaming:") || stepName.startsWith("streaming:local:")) {
                local = true;
                streaming = true;
                stepName = stepName.replace(LOCAL, "");
                stepName = stepName.replace(STREAMING, "");
            } else if (stepName.startsWith(LOCAL)) {
                local = true;
                stepName = stepName.replace(LOCAL, "");
            } else if (stepName.startsWith(STREAMING)) {
                streaming = true;
                stepName = stepName.replace(STREAMING, "");
            }
            rowLimit = parts.length >= 3 ? TransientResolver.decode(parts[2].trim()) : null;
        }
        catch (Exception ignored) {
            return null;
        }
        Optional<TransMeta> transMeta = local && this.spoonSupplier.get() != null && this.spoonSupplier.get().getActiveTransformation() != null ? Optional.of((TransMeta)this.spoonSupplier.get().getActiveTransformation().realClone(false)) : Stream.of(this.loadFromRepository(), TransMeta::new).map(loader -> loader.tryLoad(fileAndPath).orElse(null)).filter(Objects::nonNull).findFirst();
        Optional<DataServiceMeta> dataServiceMeta = transMeta.map(DataServiceMeta::new);
        if (rowLimit != null && dataServiceMeta.isPresent()) {
            dataServiceMeta.get().setRowLimit(Integer.parseInt(rowLimit));
        }
        if (streaming && dataServiceMeta.isPresent()) {
            dataServiceMeta.get().setStreaming(streaming);
        }
        dataServiceMeta.ifPresent(this.configure(dataServiceName, stepName, streaming));
        return dataServiceMeta.orElse(null);
    }

    private Consumer<DataServiceMeta> configure(String name, String step, boolean streaming) {
        return dataServiceMeta -> {
            dataServiceMeta.setStepname(step);
            dataServiceMeta.setName(name);
            if (!streaming) {
                PushDownOptimizationMeta pushDownMeta = new PushDownOptimizationMeta();
                pushDownMeta.setStepName(step);
                pushDownMeta.setType(this.cacheFactory.createPushDown());
                dataServiceMeta.setPushDownOptimizationMeta(Collections.singletonList(pushDownMeta));
            }
            dataServiceMeta.setUserDefined(false);
        };
    }

    private TransMetaLoader loadFromRepository() {
        return Optional.ofNullable(this.repositoryLocator).map(KettleRepositoryLocator::getRepository).flatMap(Optional::ofNullable).map(repository -> fileAndPath -> TransientResolver.loadFromRepository(repository, fileAndPath)).orElse(fileAndPath -> null);
    }

    private static TransMeta loadFromRepository(Repository repository, String filePath) throws KettleException {
        char fileSeparator = filePath.charAt(0);
        String name = filePath.substring(filePath.lastIndexOf(fileSeparator) + 1, filePath.length());
        String path = filePath.substring(0, filePath.lastIndexOf(fileSeparator));
        RepositoryDirectoryInterface root = repository.loadRepositoryDirectoryTree();
        RepositoryDirectoryInterface rd = root.findDirectory(path);
        if (rd == null) {
            rd = root;
        }
        return repository.loadTransformation(repository.getTransformationID(name, rd), null);
    }

    public static boolean isTransient(String dataServiceName) {
        return dataServiceName.startsWith(PREFIX);
    }

    public static String buildTransient(String filePath, String stepName) {
        return TransientResolver.buildTransient(filePath, stepName, null);
    }

    public static String buildTransient(String filePath, String stepName, Integer rowLimit) {
        return PREFIX + TransientResolver.encode(filePath) + DELIMITER + TransientResolver.encode(stepName) + (rowLimit == null ? "" : DELIMITER + TransientResolver.encode(rowLimit.toString()));
    }

    private static String encode(String value) {
        return Base64.getEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8));
    }

    private static String decode(String value) {
        return new String(Base64.getDecoder().decode(value), StandardCharsets.UTF_8);
    }

    public String[] splitTransient(String dataServiceName) {
        return dataServiceName.replace(PREFIX, "").split(DELIMITER);
    }

    @Override
    public List<String> getDataServiceNames() {
        return new ArrayList<String>();
    }

    @Override
    public List<DataServiceMeta> getDataServices(Function<Exception, Void> logger) {
        return new ArrayList<DataServiceMeta>();
    }

    private static interface TransMetaLoader {
        public TransMeta load(String var1) throws KettleException;

        default public Optional<TransMeta> tryLoad(String pathAndName) {
            try {
                return Optional.ofNullable(this.load(pathAndName));
            }
            catch (KettleException e) {
                return Optional.empty();
            }
        }
    }
}

