/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.ui;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.optimization.PushDownFactory;
import org.pentaho.di.trans.dataservice.streaming.ui.StreamingController;
import org.pentaho.di.trans.dataservice.streaming.ui.StreamingOverlay;
import org.pentaho.di.trans.dataservice.ui.DataServiceDelegate;
import org.pentaho.di.trans.dataservice.ui.controller.DataServiceDialogController;
import org.pentaho.di.trans.dataservice.ui.model.DataServiceModel;
import org.pentaho.di.ui.xul.KettleXulLoader;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulLoader;
import org.pentaho.ui.xul.XulRunner;
import org.pentaho.ui.xul.containers.XulTabbox;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.SwtXulRunner;

public class DataServiceDialog {
    private static final String XUL_DIALOG_PATH = "org/pentaho/di/trans/dataservice/ui/xul/dataservice-dialog.xul";
    private final DataServiceDialogController controller;
    private final DataServiceModel model;
    private static final Class<?> PKG = DataServiceDialog.class;

    public DataServiceDialog(DataServiceDialogController controller, DataServiceModel model) {
        this.controller = controller;
        this.model = model;
    }

    protected DataServiceDialog loadXul(Shell shell, XulLoader xulLoader, XulRunner runner) throws XulException {
        xulLoader.setOuterContext((Object)shell);
        xulLoader.registerClassLoader((Object)DataServiceDialog.class.getClassLoader());
        XulDomContainer container = xulLoader.loadXul(XUL_DIALOG_PATH, (Object)this.createResourceBundle(PKG));
        container.addEventHandler((XulEventHandler)this.controller);
        runner.addContainer(container);
        runner.initialize();
        return this;
    }

    protected ResourceBundle createResourceBundle(final Class<?> packageClass) {
        return new ResourceBundle(){

            @Override
            public Enumeration<String> getKeys() {
                return Collections.emptyEnumeration();
            }

            @Override
            protected Object handleGetObject(String key) {
                return BaseMessages.getString((Class)packageClass, (String)key, (String[])new String[0]);
            }
        };
    }

    protected DataServiceDialog initStreaming(StreamingOverlay streamingOverlay) throws KettleException {
        streamingOverlay.apply(this);
        XulTabbox optimizationTabs = (XulTabbox)this.controller.getElementById("optimizationTabs");
        if (optimizationTabs.getTabs().getTabCount() > 0) {
            optimizationTabs.setSelectedIndex(0);
        }
        return this;
    }

    protected DataServiceDialog initOptimizations(List<PushDownFactory> pushDownFactories) throws KettleException {
        ImmutableList overlays = FluentIterable.from(pushDownFactories).transform((Function)new Function<PushDownFactory, OptimizationOverlay>(){

            public OptimizationOverlay apply(PushDownFactory input) {
                return input.createOverlay();
            }
        }).filter(Predicates.notNull()).toSortedList((Comparator)Ordering.natural().onResultOf((Function)new Function<OptimizationOverlay, Comparable>(){

            public Comparable apply(OptimizationOverlay input) {
                return Double.valueOf(input.getPriority());
            }
        }));
        for (OptimizationOverlay overlay : overlays) {
            overlay.apply(this);
        }
        XulTabbox optimizationTabs = (XulTabbox)this.controller.getElementById("optimizationTabs");
        if (optimizationTabs.getTabs().getTabCount() > 0) {
            optimizationTabs.setSelectedIndex(0);
        }
        return this;
    }

    public XulDomContainer getXulDomContainer() {
        return this.controller.getXulDomContainer();
    }

    public XulDomContainer applyOverlay(OptimizationOverlay overlay, String xulSource) throws KettleException {
        XulDomContainer xulDomContainer = this.getXulDomContainer();
        try {
            xulDomContainer.loadOverlay(xulSource, (Object)this.createResourceBundle(overlay.getClass()));
        }
        catch (XulException e) {
            throw new KettleException((Throwable)e);
        }
        return xulDomContainer;
    }

    public void open() {
        this.controller.open();
    }

    public void close() {
        this.controller.close();
    }

    public DataServiceDialogController getController() {
        return this.controller;
    }

    public DataServiceModel getModel() {
        return this.model;
    }

    public static interface OptimizationOverlay {
        public double getPriority();

        public void apply(DataServiceDialog var1) throws KettleException;
    }

    public static class Builder {
        private final DataServiceModel model;
        private DataServiceMeta dataService;

        public Builder(TransMeta transMeta) {
            this(new DataServiceModel(transMeta));
        }

        public Builder(DataServiceModel model) {
            this.model = model;
        }

        public Builder serviceStep(String serviceStep) {
            this.model.setServiceStep(Strings.nullToEmpty((String)serviceStep));
            return this;
        }

        public Builder edit(DataServiceMeta dataService) {
            this.dataService = dataService;
            this.model.setStreaming(dataService.isStreaming());
            this.model.setServiceMaxRows(dataService.getRowLimit());
            this.model.setServiceMaxTime(dataService.getTimeLimit());
            this.model.setServiceName(dataService.getName());
            this.model.setServiceStep(dataService.getStepname());
            this.model.setPushDownOptimizations(dataService.getPushDownOptimizationMeta());
            return this;
        }

        protected DataServiceDialog createDialog(DataServiceDelegate delegate) {
            return new DataServiceDialog(new DataServiceDialogController(this.model, delegate), this.model);
        }

        public DataServiceDialog build(DataServiceDelegate delegate) throws KettleException {
            DataServiceDialog dialog = this.createDialog(delegate);
            dialog.getController().setDataService(this.dataService);
            try {
                dialog.loadXul(delegate.getShell(), (XulLoader)new KettleXulLoader(), (XulRunner)new SwtXulRunner());
            }
            catch (XulException xulException) {
                throw new KettleException("Failed to open the Data Service Dialog ", (Throwable)xulException);
            }
            dialog.initOptimizations(delegate.getPushDownFactories());
            StreamingController streamingController = new StreamingController();
            StreamingOverlay streamingOverlay = new StreamingOverlay(streamingController);
            dialog.initStreaming(streamingOverlay);
            return dialog;
        }
    }
}

