/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.ui.controller;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.ui.DataServiceDelegate;
import org.pentaho.di.trans.dataservice.ui.DataServiceRemapStepChooserDialog;
import org.pentaho.di.trans.dataservice.ui.controller.AbstractController;
import org.pentaho.di.trans.dataservice.ui.model.DataServiceRemapStepChooserModel;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.swt.tags.SwtDialog;
import org.pentaho.ui.xul.swt.tags.SwtListbox;

public class DataServiceRemapStepChooserDialogController
extends AbstractController {
    private static final String XUL_DIALOG_ID = "dataservice-remap-step-chooser-dialog";
    private static final String NAME = "remapStepChooserController";
    private DataServiceRemapStepChooserDialog.Action action = DataServiceRemapStepChooserDialog.Action.CANCEL;
    private static Class<?> PKG = DataServiceRemapStepChooserDialog.class;
    private DataServiceMeta dataService;
    private List<String> stepNames;
    private DataServiceRemapStepChooserModel model;
    private DataServiceDelegate dataServiceDelegate;

    public DataServiceRemapStepChooserDialogController(DataServiceRemapStepChooserModel model, DataServiceMeta dataService, List<String> stepNames, DataServiceDelegate dataServiceDelegate) {
        this.setName(NAME);
        this.model = model;
        this.dataService = dataService;
        this.stepNames = stepNames;
        this.dataServiceDelegate = dataServiceDelegate;
    }

    public void init() throws InvocationTargetException, XulException {
        this.model.setServiceStep(this.stepNames.get(0));
        ((XulLabel)this.getElementById("label1")).setValue(BaseMessages.getString(PKG, (String)"RemapStepChooserDialog.Label", (String[])new String[]{this.dataService.getName()}));
        SwtListbox steps = (SwtListbox)this.getElementById("trans-steps");
        steps.setElements(this.stepNames);
        BindingFactory bindingFactory = this.getBindingFactory();
        bindingFactory.setBindingType(Binding.Type.BI_DIRECTIONAL);
        bindingFactory.createBinding((Object)this.model, "serviceStep", (Object)steps, "selectedItem", new BindingConvertor[0]).fireSourceChanged();
    }

    public void remap() {
        this.dataService.setStepname(this.model.getServiceStep());
        try {
            this.dataServiceDelegate.save(this.dataService);
            this.action = DataServiceRemapStepChooserDialog.Action.REMAP;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dataServiceDelegate.showError("Error saving data service", "Error occurred while saving data service.");
            this.action = DataServiceRemapStepChooserDialog.Action.CANCEL;
        }
        this.getDialog().dispose();
    }

    public void cancel() {
        this.getDialog().dispose();
    }

    public DataServiceRemapStepChooserDialog.Action getAction() {
        return this.action;
    }

    SwtDialog getDialog() {
        return (SwtDialog)this.getElementById(XUL_DIALOG_ID);
    }
}

