/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.List;
import org.pentaho.di.core.annotations.CarteServlet;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.trans.dataservice.clients.DataServiceClient;
import org.pentaho.di.trans.dataservice.jdbc.api.IThinServiceInformation;
import org.pentaho.di.www.BaseCartePlugin;
import org.pentaho.di.www.CarteRequestHandler;

@CarteServlet(id="listServices", name="List data services", description="List all the available data services")
public class ListDataServicesServlet
extends BaseCartePlugin {
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/listServices";
    public static final String XML_TAG_SERVICES = "services";
    public static final String XML_TAG_SERVICE = "service";
    private final DataServiceClient client;

    public ListDataServicesServlet(DataServiceClient client) {
        this.client = client;
        this.log = client.getLogChannel();
    }

    public void handleRequest(final CarteRequestHandler.CarteRequest request) throws IOException {
        List<IThinServiceInformation> serviceInformation;
        try {
            serviceInformation = this.client.getServiceInformation();
        }
        catch (SQLException e) {
            String msg = "Failed to retrieve service info";
            this.logError(msg, e);
            request.respond(500).withMessage(msg);
            return;
        }
        request.respond(200).with("text/xml; charset=utf-8", new CarteRequestHandler.WriterResponse(){

            private void writeServiceXml(PrintWriter writer, IThinServiceInformation thinServiceInformation) throws IOException {
                writer.println(XMLHandler.openTag((String)ListDataServicesServlet.XML_TAG_SERVICE));
                writer.println(XMLHandler.addTagValue((String)"name", (String)thinServiceInformation.getName()));
                writer.println(XMLHandler.addTagValue((String)"streaming", (boolean)thinServiceInformation.isStreaming()));
                writer.println(thinServiceInformation.getServiceFields().getMetaXML());
                writer.println(XMLHandler.closeTag((String)ListDataServicesServlet.XML_TAG_SERVICE));
            }

            public void write(PrintWriter writer) throws IOException {
                writer.println(XMLHandler.getXMLHeader());
                writer.println(XMLHandler.openTag((String)ListDataServicesServlet.XML_TAG_SERVICES));
                for (IThinServiceInformation thinServiceInformation : serviceInformation) {
                    String streamingParam = request.getParameter("streaming");
                    if (streamingParam == null) {
                        this.writeServiceXml(writer, thinServiceInformation);
                        continue;
                    }
                    boolean streaming = Boolean.parseBoolean(request.getParameter("streaming"));
                    if (streaming != thinServiceInformation.isStreaming()) continue;
                    this.writeServiceXml(writer, thinServiceInformation);
                }
                writer.println(XMLHandler.closeTag((String)ListDataServicesServlet.XML_TAG_SERVICES));
            }
        });
    }

    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

