/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.mr;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class ObjectCache
implements org.apache.hadoop.hive.ql.exec.ObjectCache {
    private static final Log LOG = LogFactory.getLog((String)ObjectCache.class.getName());
    private static final boolean isDebugEnabled = LOG.isDebugEnabled();

    @Override
    public void release(String key) {
        if (isDebugEnabled) {
            LOG.debug((Object)(key + " no longer needed"));
        }
    }

    @Override
    public <T> T retrieve(String key, Callable<T> fn) throws HiveException {
        try {
            if (isDebugEnabled) {
                LOG.debug((Object)("Creating " + key));
            }
            return fn.call();
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    @Override
    public <T> Future<T> retrieveAsync(String key, Callable<T> fn) throws HiveException {
        final T value = this.retrieve(key, fn);
        return new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                return value;
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return value;
            }
        };
    }

    @Override
    public void remove(String key) {
    }
}

