/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;

public class AcidUtils {
    public static final String CONF_ACID_KEY = "hive.doing.acid";
    public static final String BASE_PREFIX = "base_";
    public static final PathFilter baseFileFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getName().startsWith(AcidUtils.BASE_PREFIX);
        }
    };
    public static final String DELTA_PREFIX = "delta_";
    public static final String DELTA_SIDE_FILE_SUFFIX = "_flush_length";
    public static final PathFilter deltaFileFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getName().startsWith(AcidUtils.DELTA_PREFIX);
        }
    };
    public static final String BUCKET_PREFIX = "bucket_";
    public static final PathFilter bucketFileFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getName().startsWith(AcidUtils.BUCKET_PREFIX) && !path.getName().endsWith(AcidUtils.DELTA_SIDE_FILE_SUFFIX);
        }
    };
    public static final String BUCKET_DIGITS = "%05d";
    public static final String LEGACY_FILE_BUCKET_DIGITS = "%06d";
    public static final String DELTA_DIGITS = "%07d";
    public static final String STATEMENT_DIGITS = "%04d";
    public static final int MAX_STATEMENTS_PER_TXN = 10000;
    public static final Pattern BUCKET_DIGIT_PATTERN = Pattern.compile("[0-9]{5}$");
    public static final Pattern LEGACY_BUCKET_DIGIT_PATTERN = Pattern.compile("^[0-9]{6}");
    public static final PathFilter originalBucketFilter = new PathFilter(){

        public boolean accept(Path path) {
            return ORIGINAL_PATTERN.matcher(path.getName()).matches();
        }
    };
    private static final Log LOG = LogFactory.getLog(AcidUtils.class);
    private static final Pattern ORIGINAL_PATTERN = Pattern.compile("[0-9]+_[0-9]+");
    public static final PathFilter hiddenFileFilter = new PathFilter(){

        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };
    private static final HadoopShims SHIMS = ShimLoader.getHadoopShims();

    private AcidUtils() {
    }

    public static Path createBucketFile(Path subdir, int bucket) {
        return new Path(subdir, BUCKET_PREFIX + String.format(BUCKET_DIGITS, bucket));
    }

    public static String deltaSubdir(long min, long max) {
        return DELTA_PREFIX + String.format(DELTA_DIGITS, min) + "_" + String.format(DELTA_DIGITS, max);
    }

    public static String deltaSubdir(long min, long max, int statementId) {
        return AcidUtils.deltaSubdir(min, max) + "_" + String.format(STATEMENT_DIGITS, statementId);
    }

    public static String baseDir(long txnId) {
        return BASE_PREFIX + String.format(DELTA_DIGITS, txnId);
    }

    public static Path createFilename(Path directory, AcidOutputFormat.Options options) {
        if (options.getOldStyle()) {
            return new Path(directory, String.format(LEGACY_FILE_BUCKET_DIGITS, options.getBucket()) + "_0");
        }
        String subdir = options.isWritingBase() ? BASE_PREFIX + String.format(DELTA_DIGITS, options.getMaximumTransactionId()) : (options.getStatementId() == -1 ? AcidUtils.deltaSubdir(options.getMinimumTransactionId(), options.getMaximumTransactionId()) : AcidUtils.deltaSubdir(options.getMinimumTransactionId(), options.getMaximumTransactionId(), options.getStatementId()));
        return AcidUtils.createBucketFile(new Path(directory, subdir), options.getBucket());
    }

    static long parseBase(Path path) {
        String filename = path.getName();
        if (filename.startsWith(BASE_PREFIX)) {
            return Long.parseLong(filename.substring(BASE_PREFIX.length()));
        }
        throw new IllegalArgumentException(filename + " does not start with " + BASE_PREFIX);
    }

    public static AcidOutputFormat.Options parseBaseBucketFilename(Path bucketFile, Configuration conf) {
        AcidOutputFormat.Options result = new AcidOutputFormat.Options(conf);
        String filename = bucketFile.getName();
        result.writingBase(true);
        if (ORIGINAL_PATTERN.matcher(filename).matches()) {
            int bucket = Integer.parseInt(filename.substring(0, filename.indexOf(95)));
            result.setOldStyle(true).minimumTransactionId(0L).maximumTransactionId(0L).bucket(bucket);
        } else if (filename.startsWith(BUCKET_PREFIX)) {
            int bucket = Integer.parseInt(filename.substring(filename.indexOf(95) + 1));
            result.setOldStyle(false).minimumTransactionId(0L).maximumTransactionId(AcidUtils.parseBase(bucketFile.getParent())).bucket(bucket);
        } else {
            result.setOldStyle(true).bucket(-1).minimumTransactionId(0L).maximumTransactionId(0L);
        }
        return result;
    }

    public static DataOperationType toDataOperationType(Operation op) {
        switch (op) {
            case NOT_ACID: {
                return DataOperationType.UNSET;
            }
            case INSERT: {
                return DataOperationType.INSERT;
            }
            case UPDATE: {
                return DataOperationType.UPDATE;
            }
            case DELETE: {
                return DataOperationType.DELETE;
            }
        }
        throw new IllegalArgumentException("Unexpected Operation: " + (Object)((Object)op));
    }

    public static Path[] getPaths(List<ParsedDelta> deltas) {
        Path[] result = new Path[deltas.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = deltas.get(i).getPath();
        }
        return result;
    }

    public static List<AcidInputFormat.DeltaMetaData> serializeDeltas(List<ParsedDelta> deltas) {
        ArrayList<AcidInputFormat.DeltaMetaData> result = new ArrayList<AcidInputFormat.DeltaMetaData>(deltas.size());
        AcidInputFormat.DeltaMetaData last = null;
        for (ParsedDelta parsedDelta : deltas) {
            if (last != null && last.getMinTxnId() == parsedDelta.getMinTransaction() && last.getMaxTxnId() == parsedDelta.getMaxTransaction()) {
                last.getStmtIds().add(parsedDelta.getStatementId());
                continue;
            }
            last = new AcidInputFormat.DeltaMetaData(parsedDelta.getMinTransaction(), parsedDelta.getMaxTransaction(), new ArrayList<Integer>());
            result.add(last);
            if (parsedDelta.statementId < 0) continue;
            last.getStmtIds().add(parsedDelta.getStatementId());
        }
        return result;
    }

    public static Path[] deserializeDeltas(Path root, List<AcidInputFormat.DeltaMetaData> deltas) throws IOException {
        ArrayList<Path> results = new ArrayList<Path>(deltas.size());
        for (AcidInputFormat.DeltaMetaData dmd : deltas) {
            if (dmd.getStmtIds().isEmpty()) {
                results.add(new Path(root, AcidUtils.deltaSubdir(dmd.getMinTxnId(), dmd.getMaxTxnId())));
                continue;
            }
            for (Integer stmtId : dmd.getStmtIds()) {
                results.add(new Path(root, AcidUtils.deltaSubdir(dmd.getMinTxnId(), dmd.getMaxTxnId(), stmtId)));
            }
        }
        return results.toArray(new Path[results.size()]);
    }

    private static ParsedDelta parseDelta(FileStatus path) {
        ParsedDelta p = AcidUtils.parsedDelta(path.getPath());
        return new ParsedDelta(p.getMinTransaction(), p.getMaxTransaction(), path, p.statementId);
    }

    public static ParsedDelta parsedDelta(Path deltaDir) {
        String filename = deltaDir.getName();
        if (filename.startsWith(DELTA_PREFIX)) {
            long max;
            String rest = filename.substring(DELTA_PREFIX.length());
            int split = rest.indexOf(95);
            int split2 = rest.indexOf(95, split + 1);
            long min = Long.parseLong(rest.substring(0, split));
            long l = max = split2 == -1 ? Long.parseLong(rest.substring(split + 1)) : Long.parseLong(rest.substring(split + 1, split2));
            if (split2 == -1) {
                return new ParsedDelta(min, max, null);
            }
            int statementId = Integer.parseInt(rest.substring(split2 + 1));
            return new ParsedDelta(min, max, null, statementId);
        }
        throw new IllegalArgumentException(deltaDir + " does not start with " + DELTA_PREFIX);
    }

    public static boolean isAcid(Path directory, Configuration conf) throws IOException {
        FileSystem fs = directory.getFileSystem(conf);
        for (FileStatus file : fs.listStatus(directory)) {
            String filename = file.getPath().getName();
            if (!filename.startsWith(BASE_PREFIX) && !filename.startsWith(DELTA_PREFIX) || !file.isDir()) continue;
            return true;
        }
        return false;
    }

    public static Directory getAcidState(Path directory, Configuration conf, ValidTxnList txnList) throws IOException {
        return AcidUtils.getAcidState(directory, conf, txnList, false);
    }

    public static Directory getAcidState(Path directory, Configuration conf, ValidTxnList txnList, boolean ignoreEmptyFiles) throws IOException {
        FileSystem fs = directory.getFileSystem(conf);
        FileStatus bestBase = null;
        long bestBaseTxn = 0L;
        long oldestBaseTxnId = Long.MAX_VALUE;
        Path oldestBase = null;
        final ArrayList<ParsedDelta> deltas = new ArrayList<ParsedDelta>();
        ArrayList<ParsedDelta> working = new ArrayList<ParsedDelta>();
        ArrayList<FileStatus> originalDirectories = new ArrayList<FileStatus>();
        final ArrayList<FileStatus> original = new ArrayList<FileStatus>();
        final ArrayList<FileStatus> obsolete = new ArrayList<FileStatus>();
        List<FileStatus> children = SHIMS.listLocatedStatus(fs, directory, hiddenFileFilter);
        for (FileStatus child : children) {
            Path p = child.getPath();
            String fn = p.getName();
            if (fn.startsWith(BASE_PREFIX) && child.isDir()) {
                long txn = AcidUtils.parseBase(p);
                if (oldestBaseTxnId > txn) {
                    oldestBase = p;
                    oldestBaseTxnId = txn;
                }
                if (bestBase == null) {
                    if (!AcidUtils.isValidBase(txn, txnList)) continue;
                    bestBase = child;
                    bestBaseTxn = txn;
                    continue;
                }
                if (bestBaseTxn < txn) {
                    if (!AcidUtils.isValidBase(txn, txnList)) continue;
                    obsolete.add(bestBase);
                    bestBase = child;
                    bestBaseTxn = txn;
                    continue;
                }
                obsolete.add(child);
                continue;
            }
            if (fn.startsWith(DELTA_PREFIX) && child.isDir()) {
                ParsedDelta delta = AcidUtils.parseDelta(child);
                if (txnList.isTxnRangeValid(delta.minTransaction, delta.maxTransaction) == ValidTxnList.RangeResponse.NONE) continue;
                working.add(delta);
                continue;
            }
            if (child.isDir()) {
                originalDirectories.add(child);
                continue;
            }
            if (ignoreEmptyFiles && child.getLen() == 0L) continue;
            original.add(child);
        }
        if (bestBase != null) {
            obsolete.addAll(original);
            obsolete.addAll(originalDirectories);
            original.clear();
            originalDirectories.clear();
        } else {
            for (FileStatus origDir : originalDirectories) {
                AcidUtils.findOriginals(fs, origDir, original);
            }
        }
        Collections.sort(working);
        long current = bestBaseTxn;
        int lastStmtId = -1;
        for (ParsedDelta next : working) {
            if (next.maxTransaction > current) {
                if (txnList.isTxnRangeValid(current + 1L, next.maxTransaction) == ValidTxnList.RangeResponse.NONE) continue;
                deltas.add(next);
                current = next.maxTransaction;
                lastStmtId = next.statementId;
                continue;
            }
            if (next.maxTransaction == current && lastStmtId >= 0) {
                deltas.add(next);
                continue;
            }
            obsolete.add(next.path);
        }
        if (oldestBase != null && bestBase == null) {
            long[] exceptions = txnList.getInvalidTransactions();
            String minOpenTxn = exceptions != null && exceptions.length > 0 ? Long.toString(exceptions[0]) : "x";
            throw new IOException(ErrorMsg.ACID_NOT_ENOUGH_HISTORY.format(Long.toString(txnList.getHighWatermark()), minOpenTxn, oldestBase.toString()));
        }
        final Path base = bestBase == null ? null : bestBase.getPath();
        LOG.debug((Object)("in directory " + directory.toUri().toString() + " base = " + base + " deltas = " + deltas.size()));
        return new Directory(){

            @Override
            public Path getBaseDirectory() {
                return base;
            }

            @Override
            public List<FileStatus> getOriginalFiles() {
                return original;
            }

            @Override
            public List<ParsedDelta> getCurrentDirectories() {
                return deltas;
            }

            @Override
            public List<FileStatus> getObsolete() {
                return obsolete;
            }
        };
    }

    private static boolean isValidBase(long baseTxnId, ValidTxnList txnList) {
        if (baseTxnId == Long.MIN_VALUE) {
            return true;
        }
        return txnList.isValidBase(baseTxnId);
    }

    private static void findOriginals(FileSystem fs, FileStatus stat, List<FileStatus> original) throws IOException {
        if (stat.isDir()) {
            for (FileStatus child : SHIMS.listLocatedStatus(fs, stat.getPath(), hiddenFileFilter)) {
                AcidUtils.findOriginals(fs, child, original);
            }
        } else {
            original.add(stat);
        }
    }

    public static boolean isTablePropertyTransactional(Properties props) {
        String resultStr = props.getProperty("transactional");
        if (resultStr == null) {
            resultStr = props.getProperty("transactional".toUpperCase());
        }
        return resultStr != null && resultStr.equalsIgnoreCase("true");
    }

    public static boolean isTablePropertyTransactional(Map<String, String> parameters) {
        String resultStr = parameters.get("transactional");
        if (resultStr == null) {
            resultStr = parameters.get("transactional".toUpperCase());
        }
        return resultStr != null && resultStr.equalsIgnoreCase("true");
    }

    public static boolean isTablePropertyTransactional(Configuration conf) {
        String resultStr = conf.get("transactional");
        if (resultStr == null) {
            resultStr = conf.get("transactional".toUpperCase());
        }
        return resultStr != null && resultStr.equalsIgnoreCase("true");
    }

    public static void setTransactionalTableScan(Map<String, String> parameters, boolean isAcidTable) {
        parameters.put(HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN.varname, Boolean.toString(isAcidTable));
    }

    public static void setTransactionalTableScan(Configuration conf, boolean isAcidTable) {
        HiveConf.setBoolVar(conf, HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN, isAcidTable);
    }

    public static boolean isAcidTable(Table table) {
        if (table == null) {
            return false;
        }
        String tableIsTransactional = table.getProperty("transactional");
        if (tableIsTransactional == null) {
            tableIsTransactional = table.getProperty("transactional".toUpperCase());
        }
        return tableIsTransactional != null && tableIsTransactional.equalsIgnoreCase("true");
    }

    public static class ParsedDelta
    implements Comparable<ParsedDelta> {
        private final long minTransaction;
        private final long maxTransaction;
        private final FileStatus path;
        private final int statementId;

        ParsedDelta(long min, long max, FileStatus path) {
            this(min, max, path, -1);
        }

        ParsedDelta(long min, long max, FileStatus path, int statementId) {
            this.minTransaction = min;
            this.maxTransaction = max;
            this.path = path;
            this.statementId = statementId;
        }

        public long getMinTransaction() {
            return this.minTransaction;
        }

        public long getMaxTransaction() {
            return this.maxTransaction;
        }

        public Path getPath() {
            return this.path.getPath();
        }

        public int getStatementId() {
            return this.statementId == -1 ? 0 : this.statementId;
        }

        @Override
        public int compareTo(ParsedDelta parsedDelta) {
            if (this.minTransaction != parsedDelta.minTransaction) {
                if (this.minTransaction < parsedDelta.minTransaction) {
                    return -1;
                }
                return 1;
            }
            if (this.maxTransaction != parsedDelta.maxTransaction) {
                if (this.maxTransaction < parsedDelta.maxTransaction) {
                    return 1;
                }
                return -1;
            }
            if (this.statementId != parsedDelta.statementId) {
                if (this.statementId < parsedDelta.statementId) {
                    return -1;
                }
                return 1;
            }
            return this.path.compareTo((Object)parsedDelta.path);
        }
    }

    public static interface Directory {
        public Path getBaseDirectory();

        public List<FileStatus> getOriginalFiles();

        public List<ParsedDelta> getCurrentDirectories();

        public List<FileStatus> getObsolete();
    }

    public static enum Operation {
        NOT_ACID,
        INSERT,
        UPDATE,
        DELETE;

    }
}

