/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.TypeDescription;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.BaseCharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;

public class OrcUtils {
    private static final Log LOG = LogFactory.getLog(OrcUtils.class);

    public static boolean[] includeColumns(String selectedColumns, String allColumns, ObjectInspector inspector) {
        int numFlattenedCols = OrcUtils.getFlattenedColumnsCount(inspector);
        boolean[] results = new boolean[numFlattenedCols];
        if ("*".equals(selectedColumns)) {
            Arrays.fill(results, true);
            return results;
        }
        if (selectedColumns != null && !selectedColumns.isEmpty()) {
            OrcUtils.includeColumnsImpl(results, selectedColumns.toLowerCase(), allColumns, inspector);
        }
        return results;
    }

    private static void includeColumnsImpl(boolean[] includeColumns, String selectedColumns, String allColumns, ObjectInspector inspector) {
        String[] selCols;
        Map<String, List<Integer>> columnSpanMap = OrcUtils.getColumnSpan(allColumns, inspector);
        LOG.info((Object)("columnSpanMap: " + columnSpanMap));
        for (String sc : selCols = selectedColumns.split(",")) {
            if (!columnSpanMap.containsKey(sc)) continue;
            List<Integer> colSpan = columnSpanMap.get(sc);
            int start = colSpan.get(0);
            int end = colSpan.get(1);
            for (int i = start; i <= end; ++i) {
                includeColumns[i] = true;
            }
        }
        LOG.info((Object)("includeColumns: " + Arrays.toString(includeColumns)));
    }

    private static Map<String, List<Integer>> getColumnSpan(String allColumns, ObjectInspector inspector) {
        HashMap<String, List<Integer>> columnSpanMap = new HashMap<String, List<Integer>>();
        if (allColumns != null) {
            String[] columns = allColumns.split(",");
            int startIdx = 0;
            int endIdx = 0;
            if (inspector instanceof StructObjectInspector) {
                StructObjectInspector soi = (StructObjectInspector)inspector;
                List<? extends StructField> fields = soi.getAllStructFieldRefs();
                for (int i = 0; i < fields.size(); ++i) {
                    StructField sf = fields.get(i);
                    ObjectInspector sfOI = sf.getFieldObjectInspector();
                    String colName = columns[i];
                    startIdx = endIdx + 1;
                    switch (sfOI.getCategory()) {
                        case PRIMITIVE: {
                            ++endIdx;
                            break;
                        }
                        case STRUCT: {
                            ++endIdx;
                            StructObjectInspector structInsp = (StructObjectInspector)sfOI;
                            List<? extends StructField> structFields = structInsp.getAllStructFieldRefs();
                            for (int j = 0; j < structFields.size(); ++j) {
                                endIdx += OrcUtils.getFlattenedColumnsCount(structFields.get(j).getFieldObjectInspector());
                            }
                            break;
                        }
                        case MAP: {
                            ++endIdx;
                            MapObjectInspector mapInsp = (MapObjectInspector)sfOI;
                            endIdx += OrcUtils.getFlattenedColumnsCount(mapInsp.getMapKeyObjectInspector());
                            endIdx += OrcUtils.getFlattenedColumnsCount(mapInsp.getMapValueObjectInspector());
                            break;
                        }
                        case LIST: {
                            ++endIdx;
                            ListObjectInspector listInsp = (ListObjectInspector)sfOI;
                            endIdx += OrcUtils.getFlattenedColumnsCount(listInsp.getListElementObjectInspector());
                            break;
                        }
                        case UNION: {
                            ++endIdx;
                            UnionObjectInspector unionInsp = (UnionObjectInspector)sfOI;
                            List<ObjectInspector> choices = unionInsp.getObjectInspectors();
                            for (int j = 0; j < choices.size(); ++j) {
                                endIdx += OrcUtils.getFlattenedColumnsCount(choices.get(j));
                            }
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Bad category: " + (Object)((Object)inspector.getCategory()));
                        }
                    }
                    columnSpanMap.put(colName, Lists.newArrayList(startIdx, endIdx));
                }
            }
        }
        return columnSpanMap;
    }

    public static int getFlattenedColumnsCount(ObjectInspector inspector) {
        int numWriters = 0;
        switch (inspector.getCategory()) {
            case PRIMITIVE: {
                ++numWriters;
                break;
            }
            case STRUCT: {
                ++numWriters;
                StructObjectInspector structInsp = (StructObjectInspector)inspector;
                List<? extends StructField> fields = structInsp.getAllStructFieldRefs();
                for (int i = 0; i < fields.size(); ++i) {
                    numWriters += OrcUtils.getFlattenedColumnsCount(fields.get(i).getFieldObjectInspector());
                }
                break;
            }
            case MAP: {
                ++numWriters;
                MapObjectInspector mapInsp = (MapObjectInspector)inspector;
                numWriters += OrcUtils.getFlattenedColumnsCount(mapInsp.getMapKeyObjectInspector());
                numWriters += OrcUtils.getFlattenedColumnsCount(mapInsp.getMapValueObjectInspector());
                break;
            }
            case LIST: {
                ++numWriters;
                ListObjectInspector listInsp = (ListObjectInspector)inspector;
                numWriters += OrcUtils.getFlattenedColumnsCount(listInsp.getListElementObjectInspector());
                break;
            }
            case UNION: {
                ++numWriters;
                UnionObjectInspector unionInsp = (UnionObjectInspector)inspector;
                List<ObjectInspector> choices = unionInsp.getObjectInspectors();
                for (int i = 0; i < choices.size(); ++i) {
                    numWriters += OrcUtils.getFlattenedColumnsCount(choices.get(i));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad category: " + (Object)((Object)inspector.getCategory()));
            }
        }
        return numWriters;
    }

    public static ArrayList<TypeDescription> typeDescriptionsFromHiveTypeProperty(String hiveTypeProperty) {
        ArrayList<TypeInfo> typeInfoList = TypeInfoUtils.getTypeInfosFromTypeString(hiveTypeProperty);
        ArrayList<TypeDescription> typeDescrList = new ArrayList<TypeDescription>(typeInfoList.size());
        for (TypeInfo typeInfo : typeInfoList) {
            typeDescrList.add(OrcUtils.convertTypeInfo(typeInfo));
        }
        return typeDescrList;
    }

    public static TypeDescription convertTypeInfo(TypeInfo info) {
        switch (info.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo pinfo = (PrimitiveTypeInfo)info;
                switch (pinfo.getPrimitiveCategory()) {
                    case BOOLEAN: {
                        return TypeDescription.createBoolean();
                    }
                    case BYTE: {
                        return TypeDescription.createByte();
                    }
                    case SHORT: {
                        return TypeDescription.createShort();
                    }
                    case INT: {
                        return TypeDescription.createInt();
                    }
                    case LONG: {
                        return TypeDescription.createLong();
                    }
                    case FLOAT: {
                        return TypeDescription.createFloat();
                    }
                    case DOUBLE: {
                        return TypeDescription.createDouble();
                    }
                    case STRING: {
                        return TypeDescription.createString();
                    }
                    case DATE: {
                        return TypeDescription.createDate();
                    }
                    case TIMESTAMP: {
                        return TypeDescription.createTimestamp();
                    }
                    case BINARY: {
                        return TypeDescription.createBinary();
                    }
                    case DECIMAL: {
                        DecimalTypeInfo dinfo = (DecimalTypeInfo)pinfo;
                        return TypeDescription.createDecimal().withScale(dinfo.getScale()).withPrecision(dinfo.getPrecision());
                    }
                    case VARCHAR: {
                        BaseCharTypeInfo cinfo = (BaseCharTypeInfo)pinfo;
                        return TypeDescription.createVarchar().withMaxLength(cinfo.getLength());
                    }
                    case CHAR: {
                        BaseCharTypeInfo cinfo = (BaseCharTypeInfo)pinfo;
                        return TypeDescription.createChar().withMaxLength(cinfo.getLength());
                    }
                }
                throw new IllegalArgumentException("ORC doesn't handle primitive category " + (Object)((Object)pinfo.getPrimitiveCategory()));
            }
            case LIST: {
                ListTypeInfo linfo = (ListTypeInfo)info;
                return TypeDescription.createList(OrcUtils.convertTypeInfo(linfo.getListElementTypeInfo()));
            }
            case MAP: {
                MapTypeInfo minfo = (MapTypeInfo)info;
                return TypeDescription.createMap(OrcUtils.convertTypeInfo(minfo.getMapKeyTypeInfo()), OrcUtils.convertTypeInfo(minfo.getMapValueTypeInfo()));
            }
            case UNION: {
                UnionTypeInfo minfo = (UnionTypeInfo)info;
                TypeDescription result = TypeDescription.createUnion();
                for (TypeInfo child : minfo.getAllUnionObjectTypeInfos()) {
                    result.addUnionChild(OrcUtils.convertTypeInfo(child));
                }
                return result;
            }
            case STRUCT: {
                StructTypeInfo sinfo = (StructTypeInfo)info;
                TypeDescription result = TypeDescription.createStruct();
                for (String fieldName : sinfo.getAllStructFieldNames()) {
                    result.addField(fieldName, OrcUtils.convertTypeInfo(sinfo.getStructFieldTypeInfo(fieldName)));
                }
                return result;
            }
        }
        throw new IllegalArgumentException("ORC doesn't handle " + (Object)((Object)info.getCategory()));
    }

    public static List<OrcProto.Type> getOrcTypes(TypeDescription typeDescr) {
        ArrayList<OrcProto.Type> result = Lists.newArrayList();
        OrcUtils.appendOrcTypes(result, typeDescr);
        return result;
    }

    private static void appendOrcTypes(List<OrcProto.Type> result, TypeDescription typeDescr) {
        OrcProto.Type.Builder type = OrcProto.Type.newBuilder();
        List<TypeDescription> children = typeDescr.getChildren();
        switch (typeDescr.getCategory()) {
            case BOOLEAN: {
                type.setKind(OrcProto.Type.Kind.BOOLEAN);
                break;
            }
            case BYTE: {
                type.setKind(OrcProto.Type.Kind.BYTE);
                break;
            }
            case SHORT: {
                type.setKind(OrcProto.Type.Kind.SHORT);
                break;
            }
            case INT: {
                type.setKind(OrcProto.Type.Kind.INT);
                break;
            }
            case LONG: {
                type.setKind(OrcProto.Type.Kind.LONG);
                break;
            }
            case FLOAT: {
                type.setKind(OrcProto.Type.Kind.FLOAT);
                break;
            }
            case DOUBLE: {
                type.setKind(OrcProto.Type.Kind.DOUBLE);
                break;
            }
            case STRING: {
                type.setKind(OrcProto.Type.Kind.STRING);
                break;
            }
            case CHAR: {
                type.setKind(OrcProto.Type.Kind.CHAR);
                type.setMaximumLength(typeDescr.getMaxLength());
                break;
            }
            case VARCHAR: {
                type.setKind(OrcProto.Type.Kind.VARCHAR);
                type.setMaximumLength(typeDescr.getMaxLength());
                break;
            }
            case BINARY: {
                type.setKind(OrcProto.Type.Kind.BINARY);
                break;
            }
            case TIMESTAMP: {
                type.setKind(OrcProto.Type.Kind.TIMESTAMP);
                break;
            }
            case DATE: {
                type.setKind(OrcProto.Type.Kind.DATE);
                break;
            }
            case DECIMAL: {
                type.setKind(OrcProto.Type.Kind.DECIMAL);
                type.setPrecision(typeDescr.getPrecision());
                type.setScale(typeDescr.getScale());
                break;
            }
            case LIST: {
                type.setKind(OrcProto.Type.Kind.LIST);
                type.addSubtypes(children.get(0).getId());
                break;
            }
            case MAP: {
                type.setKind(OrcProto.Type.Kind.MAP);
                for (TypeDescription t : children) {
                    type.addSubtypes(t.getId());
                }
                break;
            }
            case STRUCT: {
                type.setKind(OrcProto.Type.Kind.STRUCT);
                for (TypeDescription t : children) {
                    type.addSubtypes(t.getId());
                }
                for (String field : typeDescr.getFieldNames()) {
                    type.addFieldNames(field);
                }
                break;
            }
            case UNION: {
                type.setKind(OrcProto.Type.Kind.UNION);
                for (TypeDescription t : children) {
                    type.addSubtypes(t.getId());
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown category: " + (Object)((Object)typeDescr.getCategory()));
            }
        }
        result.add(type.build());
        if (children != null) {
            for (TypeDescription child : children) {
                OrcUtils.appendOrcTypes(result, child);
            }
        }
    }

    public static void appendOrcTypesRebuildSubtypes(List<OrcProto.Type> result, TypeDescription typeDescr) {
        int subtype = result.size();
        OrcProto.Type.Builder type = OrcProto.Type.newBuilder();
        boolean needsAdd = true;
        List<TypeDescription> children = typeDescr.getChildren();
        switch (typeDescr.getCategory()) {
            case BOOLEAN: {
                type.setKind(OrcProto.Type.Kind.BOOLEAN);
                break;
            }
            case BYTE: {
                type.setKind(OrcProto.Type.Kind.BYTE);
                break;
            }
            case SHORT: {
                type.setKind(OrcProto.Type.Kind.SHORT);
                break;
            }
            case INT: {
                type.setKind(OrcProto.Type.Kind.INT);
                break;
            }
            case LONG: {
                type.setKind(OrcProto.Type.Kind.LONG);
                break;
            }
            case FLOAT: {
                type.setKind(OrcProto.Type.Kind.FLOAT);
                break;
            }
            case DOUBLE: {
                type.setKind(OrcProto.Type.Kind.DOUBLE);
                break;
            }
            case STRING: {
                type.setKind(OrcProto.Type.Kind.STRING);
                break;
            }
            case CHAR: {
                type.setKind(OrcProto.Type.Kind.CHAR);
                type.setMaximumLength(typeDescr.getMaxLength());
                break;
            }
            case VARCHAR: {
                type.setKind(OrcProto.Type.Kind.VARCHAR);
                type.setMaximumLength(typeDescr.getMaxLength());
                break;
            }
            case BINARY: {
                type.setKind(OrcProto.Type.Kind.BINARY);
                break;
            }
            case TIMESTAMP: {
                type.setKind(OrcProto.Type.Kind.TIMESTAMP);
                break;
            }
            case DATE: {
                type.setKind(OrcProto.Type.Kind.DATE);
                break;
            }
            case DECIMAL: {
                type.setKind(OrcProto.Type.Kind.DECIMAL);
                type.setPrecision(typeDescr.getPrecision());
                type.setScale(typeDescr.getScale());
                break;
            }
            case LIST: {
                type.setKind(OrcProto.Type.Kind.LIST);
                type.addSubtypes(++subtype);
                result.add(type.build());
                needsAdd = false;
                OrcUtils.appendOrcTypesRebuildSubtypes(result, children.get(0));
                break;
            }
            case MAP: {
                result.add(null);
                OrcUtils.appendOrcTypesRebuildSubtypes(result, children.get(0));
                int subtype2 = result.size();
                OrcUtils.appendOrcTypesRebuildSubtypes(result, children.get(1));
                type.setKind(OrcProto.Type.Kind.MAP);
                type.addSubtypes(subtype + 1);
                type.addSubtypes(subtype2);
                result.set(subtype, type.build());
                needsAdd = false;
                break;
            }
            case STRUCT: {
                List<String> fieldNames = typeDescr.getFieldNames();
                result.add(null);
                ArrayList<Integer> fieldSubtypes = new ArrayList<Integer>(fieldNames.size());
                for (TypeDescription child : children) {
                    int fieldSubtype = result.size();
                    fieldSubtypes.add(fieldSubtype);
                    OrcUtils.appendOrcTypesRebuildSubtypes(result, child);
                }
                type.setKind(OrcProto.Type.Kind.STRUCT);
                for (int i = 0; i < fieldNames.size(); ++i) {
                    type.addSubtypes((Integer)fieldSubtypes.get(i));
                    type.addFieldNames(fieldNames.get(i));
                }
                result.set(subtype, type.build());
                needsAdd = false;
                break;
            }
            case UNION: {
                result.add(null);
                ArrayList<Integer> unionSubtypes = new ArrayList<Integer>(children.size());
                for (TypeDescription child : children) {
                    int unionSubtype = result.size();
                    unionSubtypes.add(unionSubtype);
                    OrcUtils.appendOrcTypesRebuildSubtypes(result, child);
                }
                type.setKind(OrcProto.Type.Kind.UNION);
                for (int i = 0; i < children.size(); ++i) {
                    type.addSubtypes((Integer)unionSubtypes.get(i));
                }
                result.set(subtype, type.build());
                needsAdd = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown category: " + (Object)((Object)typeDescr.getCategory()));
            }
        }
        if (needsAdd) {
            result.add(type.build());
        }
    }

    public static int appendOrcTypesRebuildSubtypes(List<OrcProto.Type> result, List<OrcProto.Type> types, int columnId) {
        OrcProto.Type oldType = types.get(columnId++);
        int subtype = result.size();
        OrcProto.Type.Builder builder = OrcProto.Type.newBuilder();
        boolean needsAdd = true;
        switch (oldType.getKind()) {
            case BOOLEAN: {
                builder.setKind(OrcProto.Type.Kind.BOOLEAN);
                break;
            }
            case BYTE: {
                builder.setKind(OrcProto.Type.Kind.BYTE);
                break;
            }
            case SHORT: {
                builder.setKind(OrcProto.Type.Kind.SHORT);
                break;
            }
            case INT: {
                builder.setKind(OrcProto.Type.Kind.INT);
                break;
            }
            case LONG: {
                builder.setKind(OrcProto.Type.Kind.LONG);
                break;
            }
            case FLOAT: {
                builder.setKind(OrcProto.Type.Kind.FLOAT);
                break;
            }
            case DOUBLE: {
                builder.setKind(OrcProto.Type.Kind.DOUBLE);
                break;
            }
            case STRING: {
                builder.setKind(OrcProto.Type.Kind.STRING);
                break;
            }
            case CHAR: {
                builder.setKind(OrcProto.Type.Kind.CHAR);
                builder.setMaximumLength(oldType.getMaximumLength());
                break;
            }
            case VARCHAR: {
                builder.setKind(OrcProto.Type.Kind.VARCHAR);
                builder.setMaximumLength(oldType.getMaximumLength());
                break;
            }
            case BINARY: {
                builder.setKind(OrcProto.Type.Kind.BINARY);
                break;
            }
            case TIMESTAMP: {
                builder.setKind(OrcProto.Type.Kind.TIMESTAMP);
                break;
            }
            case DATE: {
                builder.setKind(OrcProto.Type.Kind.DATE);
                break;
            }
            case DECIMAL: {
                builder.setKind(OrcProto.Type.Kind.DECIMAL);
                builder.setPrecision(oldType.getPrecision());
                builder.setScale(oldType.getScale());
                break;
            }
            case LIST: {
                builder.setKind(OrcProto.Type.Kind.LIST);
                builder.addSubtypes(++subtype);
                result.add(builder.build());
                needsAdd = false;
                columnId = OrcUtils.appendOrcTypesRebuildSubtypes(result, types, columnId);
                break;
            }
            case MAP: {
                result.add(null);
                columnId = OrcUtils.appendOrcTypesRebuildSubtypes(result, types, columnId);
                int subtype2 = result.size();
                columnId = OrcUtils.appendOrcTypesRebuildSubtypes(result, types, columnId);
                builder.setKind(OrcProto.Type.Kind.MAP);
                builder.addSubtypes(subtype + 1);
                builder.addSubtypes(subtype2);
                result.set(subtype, builder.build());
                needsAdd = false;
                break;
            }
            case STRUCT: {
                int i;
                List<String> fieldNames = oldType.getFieldNamesList();
                result.add(null);
                ArrayList<Integer> fieldSubtypes = new ArrayList<Integer>(fieldNames.size());
                for (i = 0; i < fieldNames.size(); ++i) {
                    int fieldSubtype = result.size();
                    fieldSubtypes.add(fieldSubtype);
                    columnId = OrcUtils.appendOrcTypesRebuildSubtypes(result, types, columnId);
                }
                builder.setKind(OrcProto.Type.Kind.STRUCT);
                for (i = 0; i < fieldNames.size(); ++i) {
                    builder.addSubtypes((Integer)fieldSubtypes.get(i));
                    builder.addFieldNames(fieldNames.get(i));
                }
                result.set(subtype, builder.build());
                needsAdd = false;
                break;
            }
            case UNION: {
                int i;
                int subtypeCount = oldType.getSubtypesCount();
                result.add(null);
                ArrayList<Integer> unionSubtypes = new ArrayList<Integer>(subtypeCount);
                for (i = 0; i < subtypeCount; ++i) {
                    int unionSubtype = result.size();
                    unionSubtypes.add(unionSubtype);
                    columnId = OrcUtils.appendOrcTypesRebuildSubtypes(result, types, columnId);
                }
                builder.setKind(OrcProto.Type.Kind.UNION);
                for (i = 0; i < subtypeCount; ++i) {
                    builder.addSubtypes((Integer)unionSubtypes.get(i));
                }
                result.set(subtype, builder.build());
                needsAdd = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown category: " + oldType.getKind());
            }
        }
        if (needsAdd) {
            result.add(builder.build());
        }
        return columnId;
    }

    public static TypeDescription convertTypeFromProtobuf(List<OrcProto.Type> types, int rootColumn) {
        OrcProto.Type type = types.get(rootColumn);
        switch (type.getKind()) {
            case BOOLEAN: {
                return TypeDescription.createBoolean();
            }
            case BYTE: {
                return TypeDescription.createByte();
            }
            case SHORT: {
                return TypeDescription.createShort();
            }
            case INT: {
                return TypeDescription.createInt();
            }
            case LONG: {
                return TypeDescription.createLong();
            }
            case FLOAT: {
                return TypeDescription.createFloat();
            }
            case DOUBLE: {
                return TypeDescription.createDouble();
            }
            case STRING: {
                return TypeDescription.createString();
            }
            case CHAR: 
            case VARCHAR: {
                TypeDescription result;
                TypeDescription typeDescription = result = type.getKind() == OrcProto.Type.Kind.CHAR ? TypeDescription.createChar() : TypeDescription.createVarchar();
                if (type.hasMaximumLength()) {
                    result.withMaxLength(type.getMaximumLength());
                }
                return result;
            }
            case BINARY: {
                return TypeDescription.createBinary();
            }
            case TIMESTAMP: {
                return TypeDescription.createTimestamp();
            }
            case DATE: {
                return TypeDescription.createDate();
            }
            case DECIMAL: {
                TypeDescription result = TypeDescription.createDecimal();
                if (type.hasScale()) {
                    result.withScale(type.getScale());
                }
                if (type.hasPrecision()) {
                    result.withPrecision(type.getPrecision());
                }
                return result;
            }
            case LIST: {
                return TypeDescription.createList(OrcUtils.convertTypeFromProtobuf(types, type.getSubtypes(0)));
            }
            case MAP: {
                return TypeDescription.createMap(OrcUtils.convertTypeFromProtobuf(types, type.getSubtypes(0)), OrcUtils.convertTypeFromProtobuf(types, type.getSubtypes(1)));
            }
            case STRUCT: {
                TypeDescription result = TypeDescription.createStruct();
                for (int f = 0; f < type.getSubtypesCount(); ++f) {
                    result.addField(type.getFieldNames(f), OrcUtils.convertTypeFromProtobuf(types, type.getSubtypes(f)));
                }
                return result;
            }
            case UNION: {
                TypeDescription result = TypeDescription.createUnion();
                for (int f = 0; f < type.getSubtypesCount(); ++f) {
                    result.addUnionChild(OrcUtils.convertTypeFromProtobuf(types, type.getSubtypes(f)));
                }
                return result;
            }
        }
        throw new IllegalArgumentException("Unknown ORC type " + type.getKind());
    }

    public static TypeDescription getDesiredRowTypeDescr(Configuration conf, boolean isAcid) throws IOException {
        String columnNameProperty = null;
        String columnTypeProperty = null;
        ArrayList<String> schemaEvolutionColumnNames = null;
        ArrayList<TypeDescription> schemaEvolutionTypeDescrs = null;
        boolean haveSchemaEvolutionProperties = false;
        if (isAcid || HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_SCHEMA_EVOLUTION)) {
            columnNameProperty = conf.get("schema.evolution.columns");
            columnTypeProperty = conf.get("schema.evolution.columns.types");
            boolean bl = haveSchemaEvolutionProperties = columnNameProperty != null && columnTypeProperty != null;
            if (haveSchemaEvolutionProperties) {
                schemaEvolutionColumnNames = Lists.newArrayList(columnNameProperty.split(","));
                if (schemaEvolutionColumnNames.size() == 0) {
                    haveSchemaEvolutionProperties = false;
                } else {
                    schemaEvolutionTypeDescrs = OrcUtils.typeDescriptionsFromHiveTypeProperty(columnTypeProperty);
                    if (schemaEvolutionTypeDescrs.size() != schemaEvolutionColumnNames.size()) {
                        haveSchemaEvolutionProperties = false;
                    }
                }
            } else if (isAcid) {
                throw new IOException(ErrorMsg.SCHEMA_REQUIRED_TO_READ_ACID_TABLES.getErrorCodedMsg());
            }
        }
        if (haveSchemaEvolutionProperties) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Using schema evolution configuration variables schema.evolution.columns " + schemaEvolutionColumnNames.toString() + " / schema.evolution.columns.types " + schemaEvolutionTypeDescrs.toString() + " (isAcid " + isAcid + ")"));
            }
        } else {
            columnNameProperty = conf.get("columns");
            columnTypeProperty = conf.get("columns.types");
            if (columnTypeProperty == null || columnNameProperty == null) {
                return null;
            }
            schemaEvolutionColumnNames = Lists.newArrayList(columnNameProperty.split(","));
            if (schemaEvolutionColumnNames.size() == 0) {
                return null;
            }
            schemaEvolutionTypeDescrs = OrcUtils.typeDescriptionsFromHiveTypeProperty(columnTypeProperty);
            if (schemaEvolutionTypeDescrs.size() != schemaEvolutionColumnNames.size()) {
                return null;
            }
            int virtualColumnClipNum = -1;
            int columnNum = 0;
            for (String columnName : schemaEvolutionColumnNames) {
                if (VirtualColumn.VIRTUAL_COLUMN_NAMES.contains(columnName)) {
                    virtualColumnClipNum = columnNum;
                    break;
                }
                ++columnNum;
            }
            if (virtualColumnClipNum != -1) {
                schemaEvolutionColumnNames = Lists.newArrayList(schemaEvolutionColumnNames.subList(0, virtualColumnClipNum));
                schemaEvolutionTypeDescrs = Lists.newArrayList(schemaEvolutionTypeDescrs.subList(0, virtualColumnClipNum));
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Using column configuration variables columns " + schemaEvolutionColumnNames.toString() + " / columns.types " + schemaEvolutionTypeDescrs.toString() + " (isAcid " + isAcid + ")"));
            }
        }
        TypeDescription result = TypeDescription.createStruct();
        for (int i = 0; i < schemaEvolutionColumnNames.size(); ++i) {
            result.addField(schemaEvolutionColumnNames.get(i), (TypeDescription)schemaEvolutionTypeDescrs.get(i));
        }
        return result;
    }
}

