/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.RelFieldTrimmer;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;

public class HiveRelFieldTrimmer
extends RelFieldTrimmer {
    private ColumnAccessInfo columnAccessInfo;
    private Map<HiveProject, Table> viewProjectToTableSchema;

    public HiveRelFieldTrimmer(SqlValidator validator) {
        super(validator);
    }

    public HiveRelFieldTrimmer(SqlValidator validator, RelFactories.ProjectFactory projectFactory, RelFactories.FilterFactory filterFactory, RelFactories.JoinFactory joinFactory, RelFactories.SemiJoinFactory semiJoinFactory, RelFactories.SortFactory sortFactory, RelFactories.AggregateFactory aggregateFactory, RelFactories.SetOpFactory setOpFactory) {
        super(validator, projectFactory, filterFactory, joinFactory, semiJoinFactory, sortFactory, aggregateFactory, setOpFactory);
    }

    public HiveRelFieldTrimmer(SqlValidator validator, RelFactories.ProjectFactory projectFactory, RelFactories.FilterFactory filterFactory, RelFactories.JoinFactory joinFactory, RelFactories.SemiJoinFactory semiJoinFactory, RelFactories.SortFactory sortFactory, RelFactories.AggregateFactory aggregateFactory, RelFactories.SetOpFactory setOpFactory, ColumnAccessInfo columnAccessInfo, Map<HiveProject, Table> viewToTableSchema) {
        super(validator, projectFactory, filterFactory, joinFactory, semiJoinFactory, sortFactory, aggregateFactory, setOpFactory);
        this.columnAccessInfo = columnAccessInfo;
        this.viewProjectToTableSchema = viewToTableSchema;
    }

    protected RelFieldTrimmer.TrimResult trimChild(RelNode rel, RelNode input, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        Util.discard((Object)rel);
        if (input.getClass().getName().endsWith("MedMdrClassExtentRel")) {
            fieldsUsed = ImmutableBitSet.range((int)input.getRowType().getFieldCount());
        }
        ImmutableList collations = RelMetadataQuery.collations((RelNode)input);
        for (RelCollation collation : collations) {
            for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
                fieldsUsed = fieldsUsed.set(fieldCollation.getFieldIndex());
            }
        }
        return this.dispatchTrimFields(input, fieldsUsed, extraFields);
    }

    public RelFieldTrimmer.TrimResult trimFields(Project project, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        for (Ord ord : Ord.zip((List)project.getProjects())) {
            if (!fieldsUsed.get(ord.i) || this.columnAccessInfo == null || this.viewProjectToTableSchema == null || !this.viewProjectToTableSchema.containsKey(project)) continue;
            Table tab = this.viewProjectToTableSchema.get(project);
            this.columnAccessInfo.add(tab.getCompleteName(), tab.getCols().get(ord.i).getName());
        }
        return super.trimFields(project, fieldsUsed, extraFields);
    }
}

