/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastDoubleToLong;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;

@VectorizedExpressions(value={CastTimestampToLong.class, CastDoubleToLong.class, CastDecimalToLong.class})
public class UDFToInteger
extends UDF {
    private final IntWritable intWritable = new IntWritable();

    public IntWritable evaluate(NullWritable i) {
        return null;
    }

    public IntWritable evaluate(BooleanWritable i) {
        if (i == null) {
            return null;
        }
        this.intWritable.set(i.get() ? 1 : 0);
        return this.intWritable;
    }

    public IntWritable evaluate(ByteWritable i) {
        if (i == null) {
            return null;
        }
        this.intWritable.set((int)i.get());
        return this.intWritable;
    }

    public IntWritable evaluate(ShortWritable i) {
        if (i == null) {
            return null;
        }
        this.intWritable.set((int)i.get());
        return this.intWritable;
    }

    public IntWritable evaluate(LongWritable i) {
        if (i == null) {
            return null;
        }
        this.intWritable.set((int)i.get());
        return this.intWritable;
    }

    public IntWritable evaluate(FloatWritable i) {
        if (i == null) {
            return null;
        }
        this.intWritable.set((int)i.get());
        return this.intWritable;
    }

    public IntWritable evaluate(DoubleWritable i) {
        if (i == null) {
            return null;
        }
        this.intWritable.set((int)i.get());
        return this.intWritable;
    }

    public IntWritable evaluate(Text i) {
        if (i == null) {
            return null;
        }
        try {
            this.intWritable.set(LazyInteger.parseInt(i.getBytes(), 0, i.getLength(), 10));
            return this.intWritable;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public IntWritable evaluate(TimestampWritable i) {
        if (i == null) {
            return null;
        }
        this.intWritable.set((int)i.getSeconds());
        return this.intWritable;
    }

    public IntWritable evaluate(HiveDecimalWritable i) {
        if (i == null) {
            return null;
        }
        this.intWritable.set(i.getHiveDecimal().intValue());
        return this.intWritable;
    }

    public IntWritable evaluate(RecordIdentifier i) {
        if (i == null) {
            return null;
        }
        this.intWritable.set(i.getBucketId());
        return this.intWritable;
    }
}

